/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.Disconnectable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IManipulationListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.PredicateEvaluatorNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalModelspaceListener
implements ICoreNotificationListener,
IManipulationListener {
    protected WeakReference<IFramework> framework;
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected ReteContainer headContainer;
    protected Map<Object, Set<PredicateEvaluatorNode>> sensitiveTerms;

    public GlobalModelspaceListener(ReteEngine<?> engine, IFramework framework) {
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.headContainer = engine.getReteNet().getHeadContainer();
        this.sensitiveTerms = new HashMap<Object, Set<PredicateEvaluatorNode>>();
        this.framework = new WeakReference<IFramework>(framework);
        framework.getTopmodel().getNotificationManager().addAllListener((ICoreNotificationListener)this);
        engine.addDisconnectable((Disconnectable)this);
    }

    public synchronized void actionPerformed(ICoreNotificationObject notification) {
        if (notification.getActionType().equals("set name")) {
            ICoreNotificationObjectSetName n = (ICoreNotificationObjectSetName)notification;
            this.notifyElementChange(n.getElement());
        } else if (notification.getActionType().equals("set value")) {
            ICoreNotificationObjectSetValue n = (ICoreNotificationObjectSetValue)notification;
            this.notifyElementChange(n.getEntity());
        } else if (notification.getActionType().equals("create instanceof")) {
            ICoreNotificationObjectCreateInstanceOf n = (ICoreNotificationObjectCreateInstanceOf)notification;
            IModelElement instance = n.getInstance();
            if (instance instanceof IEntity) {
                this.boundary.updateUnary(Direction.INSERT, (Object)instance, (Object)n.getType());
            } else if (instance instanceof IRelation) {
                IRelation relation = (IRelation)instance;
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)relation.getTo(), (Object)n.getType());
            }
            this.boundary.updateInstantiation(Direction.INSERT, (Object)n.getType(), (Object)n.getInstance());
        } else if (notification.getActionType().equals("delete instanceof")) {
            ICoreNotificationObjectDeleteInstanceOf n = (ICoreNotificationObjectDeleteInstanceOf)notification;
            IModelElement instance = n.getInstance();
            if (instance instanceof IEntity) {
                this.boundary.updateUnary(Direction.REVOKE, (Object)instance, (Object)n.getType());
            } else if (instance instanceof IRelation) {
                IRelation relation = (IRelation)instance;
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)relation.getTo(), (Object)n.getType());
            }
            this.boundary.updateInstantiation(Direction.REVOKE, (Object)n.getType(), (Object)n.getInstance());
        } else if (notification.getActionType().equals("create supertypeof")) {
            Address superRoot;
            ICoreNotificationObjectCreateSupertypeOf n = (ICoreNotificationObjectCreateSupertypeOf)notification;
            IModelElement superElement = n.getSuper();
            IModelElement subElement = n.getSub();
            this.boundary.updateGeneralization(Direction.INSERT, (Object)superElement, (Object)subElement);
            if (superElement instanceof IEntity) {
                Address superRoot2 = this.boundary.getUnaryRoot((Object)superElement);
                if (superRoot2 != null) {
                    Address subRoot = this.boundary.accessUnaryRoot((Object)subElement);
                    this.engine.getReteNet().connectRemoteNodes(subRoot, superRoot2, true);
                }
            } else if (superElement instanceof IRelation && (superRoot = this.boundary.getTernaryEdgeRoot((Object)superElement)) != null) {
                Address subRoot = this.boundary.accessTernaryEdgeRoot((Object)subElement);
                this.engine.getReteNet().connectRemoteNodes(subRoot, superRoot, true);
            }
        } else if (notification.getActionType().equals("delete supertypeof")) {
            Address superRoot;
            ICoreNotificationObjectDeleteSupertypeOf n = (ICoreNotificationObjectDeleteSupertypeOf)notification;
            IModelElement superElement = n.getSuper();
            IModelElement subElement = n.getSub();
            this.boundary.updateGeneralization(Direction.REVOKE, (Object)superElement, (Object)subElement);
            if (superElement instanceof IEntity) {
                Address superRoot3 = this.boundary.getUnaryRoot((Object)superElement);
                if (superRoot3 != null) {
                    Address subRoot = this.boundary.accessUnaryRoot((Object)subElement);
                    this.engine.getReteNet().disconnectRemoteNodes(subRoot, superRoot3, true);
                }
            } else if (superElement instanceof IRelation && (superRoot = this.boundary.getTernaryEdgeRoot((Object)superElement)) != null) {
                Address subRoot = this.boundary.accessTernaryEdgeRoot((Object)subElement);
                this.engine.getReteNet().disconnectRemoteNodes(subRoot, superRoot, true);
            }
        } else if (notification.getActionType().equals("create entity")) {
            ICoreNotificationObjectCreateEntity n = (ICoreNotificationObjectCreateEntity)notification;
            IEntity entity = n.getCreated();
            this.boundary.updateUnary(Direction.INSERT, (Object)entity, null);
            this.boundary.updateContainment(Direction.INSERT, (Object)n.getContainer(), (Object)entity);
        } else if (notification.getActionType().equals("create relation")) {
            ICoreNotificationObjectCreateRelation n = (ICoreNotificationObjectCreateRelation)notification;
            IRelation relation = n.getNewRelation();
            this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n.getFrom(), (Object)n.getTo(), null);
        } else if (notification.getActionType().equals("move element to")) {
            ICoreNotificationObjectMoveTo n = (ICoreNotificationObjectMoveTo)notification;
            IEntity element = n.getElement();
            this.boundary.updateContainment(Direction.REVOKE, (Object)n.getOldContainer(), (Object)element);
            this.boundary.updateContainment(Direction.INSERT, (Object)n.getNewContainer(), (Object)element);
            this.notifyElementChange(n.getElement());
        } else if (notification.getActionType().equals("delete entity")) {
            ICoreNotificationObjectDeleteEntity n = (ICoreNotificationObjectDeleteEntity)notification;
            IEntity entity = n.getDeleted();
            this.boundary.updateUnary(Direction.REVOKE, (Object)entity, null);
        } else if (notification.getActionType().equals("delete relation")) {
            ICoreNotificationObjectDeleteRelation n = (ICoreNotificationObjectDeleteRelation)notification;
            IRelation relation = n.getDeleted();
            this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n.getFrom(), (Object)n.getTo(), null);
        } else if (notification.getActionType().equals("delete containment")) {
            ICoreNotificationObjectDeleteContainment n = (ICoreNotificationObjectDeleteContainment)notification;
            this.boundary.updateContainment(Direction.REVOKE, (Object)n.getParent(), (Object)n.getChild());
        } else if (notification.getActionType().equals("set relation from")) {
            ICoreNotificationObjectSetRelationFrom n = (ICoreNotificationObjectSetRelationFrom)notification;
            IRelation relation = n.getRelation();
            for (IModelElement type : relation.getTypes()) {
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n.getOldFrom(), (Object)relation.getTo(), (Object)type);
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n.getNewFrom(), (Object)relation.getTo(), (Object)type);
            }
            this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n.getOldFrom(), (Object)relation.getTo(), null);
            this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n.getNewFrom(), (Object)relation.getTo(), null);
            this.notifyElementChange(relation);
        } else if (notification.getActionType().equals("set relation to")) {
            ICoreNotificationObjectSetRelationTo n = (ICoreNotificationObjectSetRelationTo)notification;
            IRelation relation = n.getRelation();
            for (IModelElement type : relation.getTypes()) {
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)n.getOldTo(), (Object)type);
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)n.getNewTo(), (Object)type);
            }
            this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)n.getOldTo(), null);
            this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)n.getNewTo(), null);
            this.notifyElementChange(relation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyElementChange(Object element) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            if (nodes != null) {
                FlatTuple tuple = new FlatTuple(element);
                for (PredicateEvaluatorNode node : nodes) {
                    this.boundary.notifyEvaluator(node.getElementChangeNotifier(), (Tuple)tuple);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSensitiveTerm(Object element, PredicateEvaluatorNode node) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            if (nodes == null) {
                nodes = new HashSet<PredicateEvaluatorNode>();
                this.sensitiveTerms.put(element, nodes);
            }
            nodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSensitiveTerm(Object element, PredicateEvaluatorNode node) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            nodes.remove(node);
            if (nodes.isEmpty()) {
                this.sensitiveTerms.remove(element);
            }
        }
    }

    public int getListenerCategory() {
        return 0;
    }

    public void disconnect() {
        ((IFramework)this.framework.get()).getTopmodel().getNotificationManager().removeAllListener((ICoreNotificationListener)this);
    }
}

