/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.util.Options;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.HyperEdgeClass;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternScaffold;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BodyScaffold<StubHandle, Collector> {
    protected SimpleReteBuilder<StubHandle, Collector> builder;
    protected GTASMBuildable<StubHandle, Collector> buildable;
    protected PatternScaffold<StubHandle, Collector> patternScaffold;
    protected GTPatternBody body;
    protected Collector collector;
    protected PatternGraph pGraph;
    protected Set<PatternNode> visitedNodes = new HashSet<PatternNode>();
    protected Set<PatternEdge> visitedEdges = new HashSet<PatternEdge>();
    protected Set<PatternEdge> edgeQueue = new TreeSet<PatternEdge>();

    public BodyScaffold(SimpleReteBuilder<StubHandle, Collector> builder, PatternScaffold<StubHandle, Collector> patternScaffold, GTPatternBody body, Collector collector) {
        this.builder = builder;
        this.buildable = patternScaffold.buildable.getNextContainer();
        this.patternScaffold = patternScaffold;
        this.body = body;
        this.collector = collector;
    }

    public void run() throws RetePatternBuildException {
        this.builder.context.logDebug("patternbody build started");
        this.pGraph = new PatternGraph(this.patternScaffold.gtPattern, this.body, this.builder);
        for (PatternEdge edge : this.pGraph.pEdges) {
            this.edgeQueue.add(edge);
        }
        int constants = this.pGraph.getConstantValues().size();
        Object[] constantValues = new Object[constants];
        Object[] constantNames = new PatternNode[constants];
        int currentConstant = 0;
        for (Map.Entry<PatternNode, Object> entry : this.pGraph.getConstantValues().entrySet()) {
            constantNames[currentConstant] = entry.getKey();
            constantValues[currentConstant] = entry.getValue();
            ++currentConstant;
        }
        Object[] objectArray = constantNames;
        int n = constantNames.length;
        int n2 = 0;
        while (n2 < n) {
            PatternNode constant = objectArray[n2];
            this.bindPNode(constant);
            ++n2;
        }
        Stub stub = this.buildable.buildStartStub(constantValues, constantNames);
        while (!this.edgeQueue.isEmpty()) {
            String msg;
            PatternEdge edge = this.edgeQueue.iterator().next();
            this.edgeQueue.remove(edge);
            this.visitedEdges.add(edge);
            if (edge.isUnsafeQuantification()) {
                String[] args = new String[]{edge.origin.toString(), this.patternScaffold.gtPattern.getName()};
                msg = "The incremental engine currently does not support unresolvable variables. Keep also in mind that certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters - [{1}] in [{2}]";
                throw new RetePatternBuildException(msg, args, (Object)this.patternScaffold.gtPattern);
            }
            if (edge.isUnsafeTypeless()) {
                String[] args = new String[]{edge.origin.toString(), this.patternScaffold.gtPattern.toString()};
                msg = "[INTERNAL ERROR] Non-typesafe check operation attempted by incremental pattern matcher without matching types - [{1}] in [{2}]";
                throw new RetePatternBuildException(msg, args, (Object)this.patternScaffold.gtPattern);
            }
            int[] nArray = edge.conveysTypeInformationIndices();
            int n3 = nArray.length;
            int msg2 = 0;
            while (msg2 < n3) {
                int index = nArray[msg2];
                this.expressTypeOnPNode(edge.nodes[index]);
                ++msg2;
            }
            if (edge.edgeClass.isJoinBased()) {
                int index;
                int oldCalibrationSize = stub.calibrationPattern.getSize();
                int oldNodes = edge.degreeOfBindingWithMultiplicity;
                int[] primaryIndices = new int[oldNodes];
                int[] sideIndices = new int[oldNodes];
                int k = 0;
                int i = 0;
                while (i < edge.nodes.length) {
                    PatternNode oldNode = edge.nodes[i];
                    if (edge.boundNodes.contains(oldNode)) {
                        primaryIndices[k] = (Integer)stub.calibrationIndex.get(oldNode);
                        sideIndices[k] = i;
                        ++k;
                    }
                    ++i;
                }
                int derivedValueIndex = edge.edgeClass == HyperEdgeClass.COUNT_PATTERN_CALL ? edge.nodes.length - 1 : -1;
                Stub sideStub = this.extractSideStub(edge);
                HashSet<PatternNode> mapped = new HashSet<PatternNode>();
                LinkedList<Integer> unmapped = new LinkedList<Integer>();
                HashMap<PatternNode, LinkedList<Integer>> occurences = new HashMap<PatternNode, LinkedList<Integer>>();
                Object object = sideIndices;
                int n4 = sideIndices.length;
                int n5 = 0;
                while (n5 < n4) {
                    index = object[n5];
                    mapped.add(edge.nodes[index]);
                    ++n5;
                }
                index = 0;
                while (index < edge.nodes.length) {
                    LinkedList<Integer> indices;
                    PatternNode newNode = edge.nodes[index];
                    if (newNode.isTouched && mapped.add(newNode)) {
                        unmapped.addLast(index);
                    }
                    if ((indices = (LinkedList<Integer>)occurences.get(newNode)) == null) {
                        indices = new LinkedList<Integer>();
                        occurences.put(newNode, indices);
                    }
                    indices.add(index);
                    ++index;
                }
                int[] complementerIndices = new int[unmapped.size()];
                int l = 0;
                object = unmapped.iterator();
                while (object.hasNext()) {
                    Integer integer = (Integer)object.next();
                    complementerIndices[l++] = integer;
                }
                TupleMask complementer = new TupleMask(complementerIndices, edge.nodes.length);
                for (Collection toBeChecked : occurences.values()) {
                    if (toBeChecked.size() > 1 && toBeChecked.contains(derivedValueIndex)) {
                        toBeChecked.remove(derivedValueIndex);
                    }
                    if (toBeChecked.size() <= 1) continue;
                    int[] indices = new int[toBeChecked.size()];
                    int m = 0;
                    for (Integer index2 : toBeChecked) {
                        indices[m++] = index2;
                    }
                    sideStub = this.buildable.buildEqualityChecker(sideStub, indices);
                }
                TupleMask primaryMask = new TupleMask(primaryIndices, stub.calibrationPattern.getSize());
                TupleMask effectiveSideMask = new TupleMask(sideIndices, edge.nodes.length);
                if (edge.edgeClass != HyperEdgeClass.COUNT_PATTERN_CALL) {
                    stub = this.buildable.buildBetaNode(stub, sideStub, primaryMask, effectiveSideMask, complementer, edge.edgeClass == HyperEdgeClass.NEGATIVE_PATTERN_CALL);
                } else {
                    Integer resultPositionInSignature = null;
                    int i2 = sideIndices.length - 1;
                    while (i2 >= 0) {
                        if (sideIndices[i2] == derivedValueIndex) {
                            resultPositionInSignature = i2;
                            break;
                        }
                        --i2;
                    }
                    TupleMask originalSideMask = resultPositionInSignature == null ? effectiveSideMask : TupleMask.omit((int)resultPositionInSignature, (int)effectiveSideMask.indices.length).transform(effectiveSideMask);
                    stub = resultPositionInSignature != null ? this.buildable.buildCountCheckBetaNode(stub, sideStub, primaryMask, originalSideMask, resultPositionInSignature) : this.buildable.buildCounterBetaNode(stub, sideStub, primaryMask, originalSideMask, complementer, edge.nodes[edge.nodes.length - 1]);
                }
                LinkedList<PatternNode> newNodes = new LinkedList<PatternNode>(edge.unboundNodes);
                for (PatternNode currentNode : newNodes) {
                    this.bindPNode(currentNode);
                }
                if (Options.injectivityStrategy != Options.InjectivityStrategy.EAGER) continue;
                stub = this.constructInjectivityCheckers(stub, oldCalibrationSize);
                continue;
            }
            HashMap<String, Integer> variableIndices = new HashMap<String, Integer>();
            PatternNode[] k = edge.nodes;
            int sideIndices = edge.nodes.length;
            int primaryIndices = 0;
            while (primaryIndices < sideIndices) {
                PatternNode pNode = k[primaryIndices];
                Integer index = (Integer)stub.calibrationIndex.get(pNode);
                variableIndices.put(pNode.name, index);
                ++primaryIndices;
            }
            Integer rhsIndex = edge.extra == null ? null : (Integer)stub.calibrationIndex.get(edge.extra);
            stub = this.buildable.buildGTASMTermChecker((Term)edge.supplierKey, (Map<String, Integer>)variableIndices, (Map<String, String>)this.pGraph.variableEquivalence, rhsIndex, (Stub<StubHandle>)stub);
        }
        if (Options.injectivityStrategy == Options.InjectivityStrategy.LAZY) {
            stub = this.constructInjectivityCheckers(stub, 0);
        }
        for (PatternNode node : this.pGraph.pNodeByName.values()) {
            if (this.visitedNodes.contains(node) || !node.isTouched) continue;
            String[] args = new String[]{node.name, this.patternScaffold.gtPattern.getName()};
            String msg = "Pattern Graph Search terminated incompletely, pattern variable {1} in pattern {2} could not be reached";
            throw new RetePatternBuildException(msg, args, (Object)this.patternScaffold.gtPattern);
        }
        int paramNum = this.patternScaffold.gtPattern.getSymParameters().size();
        int[] tI = new int[paramNum];
        int tiW = stub.calibrationPattern.getSize();
        int i = 0;
        while (i < paramNum) {
            PatternVariable variable = (PatternVariable)this.patternScaffold.gtPattern.getSymParameters().get(i);
            PatternNode pNode = this.pGraph.getPNode((Variable)variable);
            tI[i] = (Integer)stub.calibrationIndex.get(pNode);
            ++i;
        }
        TupleMask trim = new TupleMask(tI, tiW);
        Stub trimmer = this.buildable.buildTrimmer(stub, trim);
        this.buildable.buildConnection(trimmer, this.collector);
    }

    protected Stub<StubHandle> constructInjectivityCheckers(Stub<StubHandle> stub, int oldCalibrationSize) {
        int newCalibrationSize = stub.calibrationPattern.getSize();
        Stub accumulator = stub;
        int subject = oldCalibrationSize;
        while (subject < newCalibrationSize) {
            PatternNode newNode = (PatternNode)stub.calibrationPattern.get(subject);
            if (!newNode.isExemptFromInjectivity()) {
                boolean injective = this.patternScaffold.gtPattern.isDistinctMatching();
                Set<PatternNode> explicit = this.pGraph.explicitInequality.get(newNode);
                Set<PatternNode> toBeOmitted = this.pGraph.permittableEquality.get(newNode);
                LinkedList<Integer> toBeChecked = new LinkedList<Integer>();
                int j = 0;
                while (j < subject) {
                    PatternNode oldNode = (PatternNode)stub.calibrationPattern.get(j);
                    if (!oldNode.isVirtual() && !toBeOmitted.contains(oldNode) && (injective || explicit.contains(oldNode))) {
                        toBeChecked.add(j);
                    }
                    ++j;
                }
                if (!toBeChecked.isEmpty()) {
                    int[] indices = new int[toBeChecked.size()];
                    int l = 0;
                    for (Integer index : toBeChecked) {
                        indices[l++] = index;
                    }
                    accumulator = this.buildable.buildInjectivityChecker(accumulator, subject, indices);
                }
            }
            ++subject;
        }
        return accumulator;
    }

    protected Stub<StubHandle> extractSideStub(PatternEdge edge) throws RetePatternBuildException {
        FlatTuple nodes = new FlatTuple((Object[])edge.nodes);
        Object supplierKey = edge.supplierKey;
        switch (edge.edgeClass) {
            case TYPE_UNARY: {
                return this.buildable.unaryTypeStub((Tuple)nodes, supplierKey);
            }
            case TYPE_TERNARY_EDGE: {
                return this.buildable.ternaryEdgeTypeStub((Tuple)nodes, supplierKey);
            }
            case TYPE_BINARY_EDGE: {
                return this.buildable.binaryEdgeTypeStub((Tuple)nodes, supplierKey);
            }
            case CONTAINMENT_DIRECT: {
                return this.buildable.containmentDirectStub((Tuple)nodes);
            }
            case CONTAINMENT_TRANSITIVE: {
                return this.buildable.containmentTransitiveStub((Tuple)nodes);
            }
            case GENERALIZATION_DIRECT: {
                return this.buildable.generalizationDirectStub((Tuple)nodes);
            }
            case GENERALIZATION_TRANSITIVE: {
                return this.buildable.generalizationTransitiveStub((Tuple)nodes);
            }
            case INSTANTIATION_DIRECT: {
                return this.buildable.instantiationDirectStub((Tuple)nodes);
            }
            case INSTANTIATION_TRANSITIVE: {
                return this.buildable.instantiationTransitiveStub((Tuple)nodes);
            }
            case PATTERN_CALL: 
            case NEGATIVE_PATTERN_CALL: 
            case COUNT_PATTERN_CALL: {
                return this.buildable.patternCallStub((Tuple)nodes, (GTPattern)supplierKey);
            }
            case CHECK_EXPRESSION: {
                String[] args = new String[]{edge.edgeClass.toString()};
                String msg = "Cannot build standard checker, no supplier for this edge class: {1}";
                throw new RetePatternBuildException(msg, args, (Object)this.patternScaffold.gtPattern);
            }
        }
        String[] args1 = new String[]{edge.edgeClass.toString()};
        String msg1 = "No such HyperEdgeClass: {1}";
        throw new RetePatternBuildException(msg1, args1, (Object)this.patternScaffold.gtPattern);
    }

    protected void bindPNode(PatternNode currentNode) {
        if (!this.visitedNodes.contains(currentNode)) {
            this.visitedNodes.add(currentNode);
            for (PatternEdge e : this.pGraph.getEdgeList(currentNode)) {
                this.edgeQueue.remove(e);
                e.bindNode(currentNode);
                if (this.visitedEdges.contains(e)) continue;
                this.edgeQueue.add(e);
            }
        }
    }

    protected void expressTypeOnPNode(PatternNode currentNode) {
        --currentNode.lingeringTypeInfoCounter;
        for (PatternEdge e : this.pGraph.getEdgeList(currentNode)) {
            if (!e.isUnsafeTypeless()) continue;
            this.edgeQueue.remove(e);
            --e.totalLingeringTypeInfoCounter;
            if (this.visitedEdges.contains(e)) continue;
            this.edgeQueue.add(e);
        }
    }
}

