/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class DisposeFrameworkAction
extends AbstractFrameworkGUIAction {
    private boolean isEnabled = true;

    public DisposeFrameworkAction(FrameworkTreeView part) {
        this.setupInternals(part);
        this.setText("Dispose framework");
        this.setToolTipText("Dispose a framework; CAUTION: do not dispose of frameworks which are currently in use by an editor!");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        Object o;
        ISelection sel = this.iFT.getSelection();
        if (sel instanceof IStructuredSelection && (o = ((IStructuredSelection)sel).getFirstElement()) instanceof FrameworkContainer) {
            this.iViatraFramework = ((FrameworkContainer)o).getFramework();
            try {
                this.iFT.getFrameWorkManager().disposeFramework(this.iViatraFramework.getId());
                this.iFT.refreshViewer(null);
            }
            catch (Exception e) {
                this.iFT.showMessage(e.getMessage());
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void calculateEnabled() {
        ISelection sel = this.iFT.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)sel).getFirstElement();
            this.isEnabled = o instanceof FrameworkContainer;
        } else {
            this.isEnabled = false;
        }
        this.setEnabled(this.isEnabled);
        this.iFT.updateLocalToolBar();
    }
}

