/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class MergeFileAction
extends AbstractFrameworkGUIAction {
    public MergeFileAction(FrameworkTreeView part) {
        this.setupInternals(part);
        this.setText("Merge a VPML file");
        this.setToolTipText("Merge a VPML file with the Framework's modelspace");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    public void run() {
        this.refreshSelection();
        FileDialog fpd = new FileDialog(this.iFT.getSite().getShell(), 4096);
        fpd.setText("Choose a file to merge");
        fpd.setFilterNames(new String[]{"Viatra VPML files"});
        fpd.setFilterExtensions(new String[]{"*.vpml"});
        final String fn = fpd.open();
        if (fn != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("VPM merge: " + fn, 2);
                        MergeFileAction.this.iViatraFramework.mergeFile(fn);
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            FrameworkGUIPlugin.runAsLongTransaction(runnable, "VPM merge: " + fn, this.iViatraFramework);
        }
    }
}

