/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkGlobalListener;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.actions.CheckAction;
import org.eclipse.viatra2.frameworkgui.actions.ClearTagsAction;
import org.eclipse.viatra2.frameworkgui.actions.LoaderAction;
import org.eclipse.viatra2.frameworkgui.actions.MergeFileAction;
import org.eclipse.viatra2.frameworkgui.actions.NativeImportAction;
import org.eclipse.viatra2.frameworkgui.actions.extend.ContributedActionContainer;
import org.eclipse.viatra2.frameworkgui.content.IFrameworkContentProviderExtension;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.content.ITreeParent;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.imports.NativeImporterFactory;
import org.eclipse.viatra2.loaders.LoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkContainer
implements ITreeParent,
IFrameworkGlobalListener {
    public static Image fwImage = FrameworkGUIPlugin.getImageDescriptor("icons/viatra_framework.png").createImage();
    protected Set<IFrameworkContentProviderExtension> extensions;
    protected IFramework framework;
    protected FrameworkTreeView treeview;
    private MergeFileAction mergeAction;
    private CheckAction checkAction;
    private ClearTagsAction clearAction;
    private HashSet<AbstractFrameworkGUIAction> native_import_actions;
    private HashSet<AbstractFrameworkGUIAction> loader_actions;
    private HashSet<AbstractFrameworkGUIAction> contributed_actions;

    public FrameworkContainer(IFramework f, FrameworkTreeView tv) {
        this.treeview = tv;
        this.framework = f;
        f.addFrameworkGlobalListener((IFrameworkGlobalListener)this);
        this.extensions = new HashSet<IFrameworkContentProviderExtension>();
        this.native_import_actions = new HashSet();
        this.loader_actions = new HashSet();
        this.contributed_actions = new HashSet();
        this.makeActions();
        this.initializeExtensions();
    }

    public IFramework getFramework() {
        return this.framework;
    }

    protected void initializeExtensions() {
        for (IFrameworkContentProviderExtension ex : FrameworkGUIPlugin.getDefault().getContentProviders()) {
            ex.init(this.treeview, this.framework, this);
            this.extensions.add(ex);
        }
    }

    @Override
    public String getLabelText() {
        return String.valueOf(this.framework.getId()) + " (" + new File(this.framework.getCurrentFilename()).getName() + ")";
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public Set<ITreeObject> getChildren() {
        HashSet<ITreeObject> ret = new HashSet<ITreeObject>();
        for (IFrameworkContentProviderExtension e : this.extensions) {
            ret.add(e.getTopLevelEntry());
        }
        return ret;
    }

    public void dispose() {
        for (IFrameworkContentProviderExtension e : this.extensions) {
            e.dispose();
        }
        this.framework.removeFrameworkGlobalListener((IFrameworkGlobalListener)this);
    }

    @Override
    public FrameworkContainer getFrameworkContainer() {
        return this;
    }

    @Override
    public Image getLabelImage() {
        return fwImage;
    }

    @Override
    public ITreeParent getParent() {
        return null;
    }

    @Override
    public IPropertySource2 getPropertySource() {
        return null;
    }

    private void makeActions() {
        this.checkAction = new CheckAction(this.treeview);
        this.clearAction = new ClearTagsAction(this.treeview);
        this.mergeAction = new MergeFileAction(this.treeview);
        this.makeNativeImporterActions();
        this.makeLoaderActions();
        this.makeContributedActions();
    }

    private void makeContributedActions() {
        for (ContributedActionContainer c : FrameworkGUIPlugin.getDefault().getContributedActions()) {
            if (!c.enablesFor.equals(IFramework.class)) continue;
            c.action.setupInternals(this.treeview);
            this.contributed_actions.add(c.action);
        }
    }

    private void makeNativeImporterActions() {
        Map hm = this.framework.getNativeImporters();
        for (NativeImporterFactory f : hm.values()) {
            NativeImportAction a = new NativeImportAction(this.treeview, f.getId());
            String ni = f.getImporterName();
            a.setText(ni);
            a.setToolTipText(ni);
            a.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            this.native_import_actions.add(a);
        }
    }

    private void makeLoaderActions() {
        Map hm = this.framework.getLoaders();
        for (LoaderFactory f : hm.values()) {
            LoaderAction a = new LoaderAction(this.treeview, f.getId());
            String ni = f.getLoaderName();
            a.setText(ni);
            a.setToolTipText(ni);
            a.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            this.loader_actions.add(a);
        }
    }

    @Override
    public Collection<IAction> getActions() {
        Vector<IAction> v = new Vector<IAction>();
        v.add((IAction)this.mergeAction);
        v.add((IAction)this.checkAction);
        v.add((IAction)this.clearAction);
        return v;
    }

    @Override
    public Collection<IContributionItem> getContributionItems() {
        Vector<IContributionItem> v = new Vector<IContributionItem>();
        if (this.native_import_actions != null && this.native_import_actions.size() > 0) {
            MenuManager nativemgr = new MenuManager("Native importers");
            for (AbstractFrameworkGUIAction a : this.native_import_actions) {
                nativemgr.add((IAction)a);
            }
            v.add((IContributionItem)nativemgr);
        }
        if (this.loader_actions != null && this.loader_actions.size() > 0) {
            MenuManager loadermgr = new MenuManager("Program loaders");
            for (AbstractFrameworkGUIAction a : this.loader_actions) {
                loadermgr.add((IAction)a);
            }
            v.add((IContributionItem)loadermgr);
        }
        if (this.contributed_actions != null && this.contributed_actions.size() > 0) {
            MenuManager contrmgr = new MenuManager("Contributions");
            for (AbstractFrameworkGUIAction a : this.contributed_actions) {
                contrmgr.add((IAction)a);
            }
            v.add((IContributionItem)contrmgr);
        }
        return v;
    }

    @Override
    public IAction getDoubleClickAction() {
        return null;
    }

    public void frameworkNameChanged() {
        this.treeview.refreshViewer(this);
    }
}

