/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content.transformation;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.TransformationContent;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;

public class SaveModelAction
extends AbstractFrameworkGUIAction {
    public SaveModelAction(FrameworkTreeView part) {
        this.setupInternals(part);
        this.setText("Save as module");
        this.setToolTipText("Saves the program model as an XMI file");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        this.refreshSelection();
        try {
            Object c = this.getFirstSelected();
            if (c instanceof TransformationContent.MachineDummy) {
                Machine m = ((TransformationContent.MachineDummy)c).machine;
                SaveAsDialog d = new SaveAsDialog(this.iFT.getViewSite().getShell());
                d.setOriginalName(String.valueOf(m.getName()) + ".module");
                if (d.open() == 0) {
                    IPath result = d.getResult();
                    ResourceSetImpl rs = new ResourceSetImpl();
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    String wsroot = ws.getRoot().getRawLocation().toOSString();
                    Resource res = rs.createResource(URI.createFileURI((String)(String.valueOf(wsroot) + result.toOSString())));
                    res.getContents().add((Object)m.getModule());
                    res.save(null);
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            this.iFT.showMessage(e.getMessage());
        }
    }
}

