/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class FrameworkDropTargetAdapter
extends DropTargetAdapter {
    private FrameworkTreeView iFT;
    static FileTransfer transfer = FileTransfer.getInstance();

    public FrameworkDropTargetAdapter(FrameworkTreeView part) {
        this.iFT = part;
    }

    public static Transfer[] getTransfers() {
        Transfer[] transfers = new Transfer[]{transfer};
        return transfers;
    }

    public void drop(DropTargetEvent event) {
        Object target;
        final String[] filenames = (String[])event.data;
        if (event.item != null && (target = event.item.getData()) != null && target instanceof FrameworkContainer) {
            int i = 0;
            while (i < filenames.length) {
                final IFramework fw = ((FrameworkContainer)target).getFramework();
                String extension = filenames[i].substring(filenames[i].lastIndexOf(".") + 1);
                final int _i = i;
                Object targetRunnable = null;
                IRunnableWithProgress runnable_merge = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("VPM merge: " + filenames[_i], 2);
                            fw.mergeFile(filenames[_i]);
                            monitor.done();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                String loaderID = "";
                final Set loaders = fw.getLoadersForExtension(extension);
                if (loaders.size() > 1) {
                    Object[] o;
                    ListDialog dialog = new ListDialog(this.iFT.getSite().getShell());
                    dialog.setTitle("Select loader to use for " + filenames[i]);
                    dialog.setAddCancelButton(true);
                    dialog.setBlockOnOpen(true);
                    dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                    dialog.setContentProvider(new IStructuredContentProvider(){

                        public Object[] getElements(Object inputElement) {
                            return loaders.toArray();
                        }

                        public void dispose() {
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }
                    });
                    dialog.setInput((Object)"blablabla");
                    int result = dialog.open();
                    if (result == 0 && (o = dialog.getResult()) != null && o.length > 0) {
                        loaderID = o[0].toString();
                    }
                } else if (loaders.size() == 1) {
                    loaderID = ((String)loaders.iterator().next()).toString();
                }
                final String _loaderID = loaderID;
                IRunnableWithProgress runnable_load = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("Machine load: " + filenames[_i], 2);
                            Long c = System.currentTimeMillis();
                            fw.loadMachine(filenames[_i], _loaderID);
                            Long c2 = System.currentTimeMillis();
                            fw.getLogger().info("Machine loading using '" + _loaderID + "' lasted for " + new Long(c2 - c).toString() + " ms");
                            monitor.done();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                String importerID = "";
                final Set importers = fw.getNativeImportersForExtension(extension);
                if (importers.size() > 1) {
                    Object[] o;
                    ListDialog dialog = new ListDialog(this.iFT.getSite().getShell());
                    dialog.setTitle("Select native importer to use for " + filenames[i]);
                    dialog.setAddCancelButton(true);
                    dialog.setBlockOnOpen(true);
                    dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                    dialog.setContentProvider(new IStructuredContentProvider(){

                        public Object[] getElements(Object inputElement) {
                            return importers.toArray();
                        }

                        public void dispose() {
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }
                    });
                    dialog.setInput((Object)"blablabla");
                    int result = dialog.open();
                    if (result == 0 && (o = dialog.getResult()) != null && o.length > 0) {
                        importerID = o[0].toString();
                    }
                } else if (importers.size() == 1) {
                    importerID = ((String)importers.iterator().next()).toString();
                }
                final String _importerID = importerID;
                IRunnableWithProgress runnable_import = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("Native import: " + filenames[_i], 2);
                            Long c = System.currentTimeMillis();
                            fw.nativeImport(filenames[_i], _importerID);
                            Long c2 = System.currentTimeMillis();
                            fw.getLogger().info("Native import using '" + _importerID + "' lasted for " + new Long(c2 - c).toString() + " ms");
                            monitor.done();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                if (extension.equalsIgnoreCase("vpml")) {
                    targetRunnable = runnable_merge;
                } else if (loaderID.length() > 0) {
                    targetRunnable = runnable_load;
                } else if (importerID.length() > 0) {
                    targetRunnable = runnable_import;
                }
                FrameworkGUIPlugin.runAsLongTransaction(targetRunnable, "Drag-and-drop operation", fw);
                ++i;
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
        this.dragOver(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = event.item == null || event.item.getData() == null || !(event.item.getData() instanceof FrameworkContainer) ? 0 : 1;
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.dragOver(event);
    }
}

