/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.actions.DisposeFrameworkAction;
import org.eclipse.viatra2.frameworkgui.content.FrameworkViewContentProvider;
import org.eclipse.viatra2.frameworkgui.content.FrameworkViewLabelProvider;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.content.NameSorter;
import org.eclipse.viatra2.frameworkgui.property.MultiPropertySheetPage;
import org.eclipse.viatra2.frameworkgui.views.FrameworkDropTargetAdapter;

public class FrameworkTreeView
extends ViewPart
implements ISelectionListener {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private DisposeFrameworkAction deleteAction;
    private Action refreshAction;
    private Action doubleClickAction;
    private FrameworkManager iFrameworkManager;

    public FrameworkManager getFrameWorkManager() {
        return this.iFrameworkManager;
    }

    public void refreshViewer(final Object o) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!FrameworkTreeView.this.viewer.getTree().isDisposed()) {
                    if (o == null) {
                        FrameworkTreeView.this.viewer.refresh();
                    } else {
                        FrameworkTreeView.this.viewer.refresh(o, true);
                        FrameworkTreeView.this.viewer.expandToLevel(o, -1);
                    }
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.iFrameworkManager = FrameworkManager.getInstance();
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new FrameworkViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new FrameworkViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer.addDropSupport(3, FrameworkDropTargetAdapter.getTransfers(), (DropTargetListener)new FrameworkDropTargetAdapter(this));
        this.makeStaticActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FrameworkTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void updateLocalToolBar() {
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection s = (IStructuredSelection)this.getSelection();
        Object first = s.getFirstElement();
        if (first instanceof ITreeObject) {
            if (((ITreeObject)first).getActions() != null) {
                for (IAction a : ((ITreeObject)first).getActions()) {
                    manager.add(a);
                }
            }
            if (((ITreeObject)first).getContributionItems() != null) {
                for (IContributionItem i : ((ITreeObject)first).getContributionItems()) {
                    manager.add(i);
                }
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.removeAll();
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.deleteAction);
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeStaticActions() {
        this.deleteAction = new DisposeFrameworkAction(this);
        this.refreshAction = new Action(){

            public void run() {
                FrameworkTreeView.this.refreshViewer(null);
                System.gc();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh view");
        this.refreshAction.setImageDescriptor(FrameworkGUIPlugin.getImageDescriptor("icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ITreeObject to;
                ISelection selection = FrameworkTreeView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ITreeObject && (to = (ITreeObject)obj).getDoubleClickAction() != null) {
                    to.getDoubleClickAction().run();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FrameworkTreeView.this.doubleClickAction.run();
            }
        });
    }

    public void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"VIATRA2 R3", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new MultiPropertySheetPage((IWorkbenchPart)this);
        }
        return super.getAdapter(type);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActivePart()) && this.deleteAction != null) {
            this.deleteAction.calculateEnabled();
        }
    }
}

