/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.code;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.buffers.IBufferStoreListener;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.frameworkgui.views.code.ColorFactory;
import org.eclipse.viatra2.frameworkgui.views.code.SaveAllBuffersAction;
import org.eclipse.viatra2.frameworkgui.views.code.SaveOutputAction;
import org.eclipse.viatra2.frameworkgui.views.code.ToggleAction;

public class CodeBufferView
extends ViewPart
implements IFrameworkListChangedListener {
    public static final String ID = "org.eclipse.viatra2.gui.codebufferview";
    public boolean isBuffering = true;
    protected CTabFolder tabFolder;
    private Map<String, DummyPage> pages = new HashMap<String, DummyPage>();

    private CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
        this.pageChange(pageIndex);
    }

    private CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    protected String getPageText(int pageIndex) {
        return this.getItem(pageIndex).getText();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(parent, 0x800400);
        this.tabFolder.setSimple(false);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = CodeBufferView.this.tabFolder.indexOf((CTabItem)e.item);
                CodeBufferView.this.pageChange(newPageIndex);
            }
        });
        this.createPages();
        if (this.getPageCount() > 0 && this.getActivePage() == -1) {
            this.setActivePage(0);
        }
        FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
        this.addToolbarActions();
    }

    private void addToolbarActions() {
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new SaveAllBuffersAction(this));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new SaveOutputAction(this));
        Action action = new Action("Clear buffer"){

            public void run() {
                int outerindex = CodeBufferView.this.getActivePage();
                int innerindex = ((DummyPage)((CodeBufferView)CodeBufferView.this).getItem((int)outerindex).getData()).internalFolder.getSelectionIndex();
                DummyPage p = (DummyPage)CodeBufferView.this.getItem(outerindex).getData();
                if (innerindex == 0) {
                    p.clear();
                } else {
                    try {
                        DummyPage.DummyBufferPage pp = (DummyPage.DummyBufferPage)((DummyPage)((CodeBufferView)CodeBufferView.this).getItem((int)outerindex).getData()).internalFolder.getItem(innerindex).getData();
                        Framework fw = FrameworkManager.getInstance().getFramework(p.frameworkId);
                        ((StringWriter)BufferStore.getBuffer((IModelSpace)fw.getTopmodel(), (String)pp.key)).getBuffer().setLength(0);
                        ((StringWriter)BufferStore.getBuffer((IModelSpace)fw.getTopmodel(), (String)pp.key)).getBuffer().trimToSize();
                        p.refreshContent();
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
        };
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        action.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        action.setToolTipText("Clear output");
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleAction(this));
    }

    public DummyPage getCurrentOuterPage() {
        int outerindex = this.getActivePage();
        DummyPage p = (DummyPage)this.getItem(outerindex).getData();
        return p;
    }

    public DummyPage.DummyBufferPage getCurrentInnerPage() {
        try {
            int outerindex = this.getActivePage();
            int innerindex = ((DummyPage)this.getItem((int)outerindex).getData()).internalFolder.getSelectionIndex();
            return (DummyPage.DummyBufferPage)((DummyPage)this.getItem((int)outerindex).getData()).internalFolder.getItem(innerindex).getData();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void createPages() {
        String[] stringArray = FrameworkManager.getInstance().getAllFrameWorks();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.createNewPage(id);
            ++n2;
        }
    }

    private void createNewPage(String _id) {
        String id = _id;
        DummyPage p = new DummyPage(id);
        this.pages.put(id, p);
        int index = this.getPageCount();
        Control control = p.createPageControl((Composite)this.getTabFolder());
        CTabItem item = new CTabItem(this.getTabFolder(), 0, index);
        item.setControl(control);
        item.setData((Object)p);
        p.externalTabItem = item;
        this.setPageText(index, id);
    }

    private void removePage(String _id) {
        final String id = _id;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DummyPage p = (DummyPage)CodeBufferView.this.pages.get(id);
                if (p != null) {
                    p.disposePage();
                    CodeBufferView.this.pages.remove(id);
                }
            }
        });
    }

    protected void pageChange(int newPageIndex) {
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
    }

    public void frameworkAdded(final IFramework f) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CodeBufferView.this.createNewPage(f.getId());
                CodeBufferView.this.setActivePage(CodeBufferView.this.getPageCount() - 1);
            }
        });
    }

    public void frameworkRemoved(final IFramework f) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CodeBufferView.this.removePage(f.getId());
            }
        });
    }

    public void dispose() {
        FrameworkManager.getInstance().removeFrameworkListChangedListener((IFrameworkListChangedListener)this);
        for (String id : this.pages.keySet()) {
            this.removePage(id);
        }
        super.dispose();
    }

    protected class DummyPage
    implements ICoreNotificationListener,
    IBufferStoreListener,
    CodeOutputPlugin {
        protected Text defaultDisplay;
        protected StringBuffer defaultBuffer;
        protected CTabItem defaultItem;
        protected CTabFolder internalFolder;
        protected Map<String, DummyBufferPage> internalPages;
        protected String frameworkId;
        protected Item externalTabItem;

        public DummyPage(String id) {
            this.frameworkId = id;
            this.defaultBuffer = new StringBuffer();
            this.internalPages = new HashMap<String, DummyBufferPage>();
            Framework fw = FrameworkManager.getInstance().getFramework(this.frameworkId);
            fw.addCodeOutListener((CodeOutputPlugin)this);
            fw.getTopmodel().getNotificationManager().addAllListener((ICoreNotificationListener)this);
        }

        public void disposePage() {
            Framework fw = FrameworkManager.getInstance().getFramework(this.frameworkId);
            if (fw != null) {
                fw.removeCodeOutListener((CodeOutputPlugin)this);
                fw.getTopmodel().getNotificationManager().removeAllListener((ICoreNotificationListener)this);
            }
            BufferStore.removeListener((IBufferStoreListener)this);
            this.externalTabItem.dispose();
        }

        public Control createPageControl(Composite parent) {
            this.internalFolder = new CTabFolder(parent, 0x800400);
            this.internalFolder.setSimple(false);
            this.defaultItem = new CTabItem(this.internalFolder, 0);
            this.defaultItem.setText("default");
            this.defaultDisplay = new Text((Composite)this.internalFolder, 778);
            if (System.getProperty("file.separator").equals("/")) {
                FontData fd = new FontData("Monospace", 10, 0);
                this.defaultDisplay.setFont(new Font((Device)Display.getDefault(), fd));
            } else {
                FontData fd = new FontData("Courier New", 10, 0);
                this.defaultDisplay.setFont(new Font((Device)Display.getDefault(), fd));
            }
            this.defaultItem.setControl((Control)this.defaultDisplay);
            this.defaultItem.setData((Object)this.defaultDisplay);
            this.defaultDisplay.setBackground(ColorFactory.getColor(255, 255, 255));
            this.defaultDisplay.setForeground(ColorFactory.getColor(0, 0, 0));
            this.internalFolder.setSelection(this.defaultItem);
            BufferStore.addListener((IBufferStoreListener)this);
            return this.internalFolder;
        }

        public void refreshContent() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DummyPage.this.defaultDisplay.setText(DummyPage.this.defaultBuffer.toString());
                    for (DummyBufferPage p : DummyPage.this.internalPages.values()) {
                        p.refresh();
                    }
                }
            });
        }

        public void clear() {
            this.defaultBuffer = new StringBuffer();
            this.refreshContent();
        }

        public void beginWork() {
        }

        public void codeOut(final String s) {
            if (!CodeBufferView.this.isBuffering) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        DummyPage.this.defaultDisplay.append(s);
                        for (DummyBufferPage p : DummyPage.this.internalPages.values()) {
                            p.refresh();
                        }
                    }
                });
            } else {
                this.defaultBuffer.append(s);
            }
        }

        public void endWork() {
        }

        public void init(IFramework fw) {
            fw.getLogger().info("Textual Output View buffer for framework " + this.frameworkId + " initialized.");
        }

        public void actionPerformed(ICoreNotificationObject notification) {
            if (!CodeBufferView.this.isBuffering) {
                return;
            }
            String type = notification.getActionType();
            if (type.equals("end transaction")) {
                this.refreshContent();
            }
        }

        public int getListenerCategory() {
            return 0;
        }

        public void bufferAdded(final String newKey) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DummyPage.this.internalPages.put(newKey, new DummyBufferPage(newKey));
                }
            });
        }

        public void bufferRemoved(String removedKey) {
        }

        protected class DummyBufferPage {
            CTabItem item;
            Text text;
            String key;

            public DummyBufferPage(String aKey) {
                this.key = aKey;
                this.item = new CTabItem(DummyPage.this.internalFolder, 0);
                this.text = new Text((Composite)DummyPage.this.internalFolder, 778);
                if (System.getProperty("file.separator").equals("/")) {
                    FontData fd = new FontData("Monospace", 10, 0);
                    this.text.setFont(new Font((Device)Display.getDefault(), fd));
                } else {
                    FontData fd = new FontData("Courier New", 10, 0);
                    this.text.setFont(new Font((Device)Display.getDefault(), fd));
                }
                this.text.setBackground(ColorFactory.getColor(255, 255, 255));
                this.text.setForeground(ColorFactory.getColor(0, 0, 0));
                this.item.setText(this.key);
                this.item.setControl((Control)this.text);
                this.item.setData((Object)this);
                DummyPage.this.internalFolder.setSelection(this.item);
            }

            public void refresh() {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            DummyBufferPage.this.text.setText(((StringWriter)BufferStore.getBuffer((IModelSpace)FrameworkManager.getInstance().getFramework(((DummyBufferPage)DummyBufferPage.this).DummyPage.this.frameworkId).getTopmodel(), (String)DummyBufferPage.this.key)).getBuffer().toString());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                        }
                        catch (IOException iOException) {}
                    }
                });
            }
        }
    }
}

