/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.eclipse.viatra2.frameworkgui.views.code.ColorFactory;
import org.eclipse.viatra2.frameworkgui.views.console.SimpleBorderLayout;
import org.eclipse.viatra2.frameworkgui.views.console.ToggleAction;
import org.eclipse.viatra2.frameworkgui.views.console.commands.CommandExecutor;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.ParsedCommand;
import org.eclipse.viatra2.logger.Logger;

public class ConsoleView
extends ViewPart
implements IFrameworkListChangedListener {
    public static final String ID = "org.eclipse.viatra2.gui.console";
    public boolean isBuffering = true;
    protected CTabFolder tabFolder;
    private Map<String, ConsolePage> pages = new HashMap<String, ConsolePage>();
    public boolean warnings = true;
    public boolean errors = true;
    public boolean infos = true;
    public boolean debugs = false;

    private CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
        this.pageChange(pageIndex);
    }

    private CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    protected String getPageText(int pageIndex) {
        return this.getItem(pageIndex).getText();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(parent, 0x800080);
        this.tabFolder.setSimple(false);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = ConsoleView.this.tabFolder.indexOf((CTabItem)e.item);
                ConsoleView.this.pageChange(newPageIndex);
            }
        });
        this.createPages();
        if (this.getPageCount() > 0 && this.getActivePage() == -1) {
            this.setActivePage(0);
        }
        FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
        this.addToolbarActions();
    }

    private void addToolbarActions() {
        Action action = new Action("Clear log"){

            public void run() {
                int outerindex = ConsoleView.this.getActivePage();
                ConsolePage p = (ConsolePage)ConsoleView.this.getItem(outerindex).getData();
                p.clear();
            }
        };
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        action.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        action.setToolTipText("Clear log");
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleAction(this, "Info", "infos"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleAction(this, "Warning", "warnings"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleAction(this, "Error", "errors"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ToggleAction(this, "Debug", "debugs"));
    }

    public ConsolePage getCurrentOuterPage() {
        int outerindex = this.getActivePage();
        ConsolePage p = (ConsolePage)this.getItem(outerindex).getData();
        return p;
    }

    protected void createPages() {
        String[] stringArray = FrameworkManager.getInstance().getAllFrameWorks();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.createNewPage(id);
            ++n2;
        }
    }

    private void createNewPage(String _id) {
        String id = _id;
        ConsolePage p = new ConsolePage(id);
        this.pages.put(id, p);
        int index = this.getPageCount();
        Control control = p.createPageControl((Composite)this.getTabFolder());
        CTabItem item = new CTabItem(this.getTabFolder(), 0, index);
        item.setControl(control);
        item.setData((Object)p);
        p.externalTabItem = item;
        this.setPageText(index, id);
    }

    private void removePage(String _id) {
        final String id = _id;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ConsolePage p = (ConsolePage)ConsoleView.this.pages.get(id);
                if (p != null) {
                    p.disposePage();
                    ConsoleView.this.pages.remove(id);
                }
            }
        });
    }

    protected void pageChange(int newPageIndex) {
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
    }

    public void frameworkAdded(final IFramework f) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ConsoleView.this.createNewPage(f.getId());
                ConsoleView.this.setActivePage(ConsoleView.this.getPageCount() - 1);
            }
        });
    }

    public void frameworkRemoved(final IFramework f) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ConsoleView.this.removePage(f.getId());
            }
        });
    }

    public void dispose() {
        FrameworkManager.getInstance().removeFrameworkListChangedListener((IFrameworkListChangedListener)this);
        for (String id : this.pages.keySet()) {
            this.removePage(id);
        }
        super.dispose();
    }

    protected class ConsolePage
    implements Logger {
        protected Text defaultDisplay;
        protected StringBuffer defaultBuffer;
        protected String frameworkId;
        protected Item externalTabItem;
        private Text commandField;
        private int currentBackwardIndex = 0;
        private int currentContentAssistIndex = 0;

        public ConsolePage(String id) {
            this.frameworkId = id;
            this.defaultBuffer = new StringBuffer();
            Framework fw = FrameworkManager.getInstance().getFramework(this.frameworkId);
            fw.addLoggerListener((Logger)this);
        }

        public void disposePage() {
            Framework fw = FrameworkManager.getInstance().getFramework(this.frameworkId);
            if (fw != null) {
                fw.removeLoggerListener((Logger)this);
            }
            this.externalTabItem.dispose();
        }

        public Control createPageControl(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new SimpleBorderLayout());
            this.defaultDisplay = new Text(c, 778);
            this.defaultDisplay.setLayoutData((Object)SimpleBorderLayout.CENTER);
            if (System.getProperty("file.separator").equals("/")) {
                FontData fd = new FontData("Monospace", 10, 0);
                this.defaultDisplay.setFont(new Font((Device)Display.getDefault(), fd));
            } else {
                FontData fd = new FontData("Courier New", 10, 0);
                this.defaultDisplay.setFont(new Font((Device)Display.getDefault(), fd));
            }
            this.defaultDisplay.setBackground(ColorFactory.getColor(255, 255, 255));
            this.defaultDisplay.setForeground(ColorFactory.getColor(0, 0, 0));
            this.commandField = new Text(c, 2052);
            this.commandField.setLayoutData((Object)SimpleBorderLayout.SOUTH);
            this.commandField.setText("");
            this.commandField.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.keyCode == 9) {
                        e.doit = false;
                    }
                }
            });
            this.commandField.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    Framework fw = FrameworkManager.getInstance().getFramework(ConsolePage.this.frameworkId);
                    if (e.keyCode == 13) {
                        ParsedCommand cmd = CommandExecutor.getParsedCommand(ConsolePage.this.commandField.getText());
                        if (cmd.isValid) {
                            ConsolePage.this.defaultBuffer.append("> " + cmd.cmdName + "(" + cmd.params.toString() + ")\n");
                            if (CommandExecutor.executeCommand((IFramework)fw, cmd)) {
                                CommandExecutor.storeCommand((IFramework)fw, ConsolePage.this.commandField.getText());
                                ConsolePage.this.commandField.setText("");
                                ConsolePage.this.currentBackwardIndex = 0;
                            } else {
                                fw.getLogger().error("Could not find VIATRA Console command by name: " + cmd.cmdName);
                            }
                        } else {
                            fw.getLogger().error("Parsing error for command: " + ConsolePage.this.commandField.getText());
                        }
                    } else if (e.keyCode == 0x1000001) {
                        ConsolePage consolePage = ConsolePage.this;
                        consolePage.currentBackwardIndex = consolePage.currentBackwardIndex + 1;
                        String oldCmd = CommandExecutor.getCommandAtBackwardIndex((IFramework)fw, ConsolePage.this.currentBackwardIndex);
                        if (oldCmd != null) {
                            ConsolePage.this.commandField.setText(oldCmd);
                            ConsolePage.this.commandField.selectAll();
                        }
                    } else if (e.keyCode == 0x1000002) {
                        ConsolePage consolePage = ConsolePage.this;
                        consolePage.currentBackwardIndex = consolePage.currentBackwardIndex - 1;
                        String oldCmd = CommandExecutor.getCommandAtBackwardIndex((IFramework)fw, ConsolePage.this.currentBackwardIndex);
                        if (oldCmd != null) {
                            ConsolePage.this.commandField.setText(oldCmd);
                            ConsolePage.this.commandField.selectAll();
                        } else {
                            ConsolePage.this.commandField.setText("");
                        }
                    } else if (e.keyCode == 9) {
                        List<IVIATRAConsoleCommandProvider> matches;
                        String prefix = ConsolePage.this.commandField.getText();
                        if (ConsolePage.this.commandField.getSelectionCount() > 0) {
                            prefix = ConsolePage.this.commandField.getText().substring(0, ConsolePage.this.commandField.getText().indexOf(ConsolePage.this.commandField.getSelectionText()));
                        }
                        if ((matches = CommandExecutor.getCommandByNamePrefix((IFramework)fw, prefix)).size() > 0) {
                            ConsolePage.this.currentContentAssistIndex = Math.max(0, ConsolePage.this.currentContentAssistIndex);
                            ConsolePage.this.currentContentAssistIndex = Math.min(matches.size() - 1, ConsolePage.this.currentContentAssistIndex);
                            ConsolePage.this.commandField.setText(matches.get(ConsolePage.this.currentContentAssistIndex).getCommandSignature());
                            ConsolePage.this.commandField.setSelection(prefix.length(), ConsolePage.this.commandField.getText().length());
                            if (matches.size() == ConsolePage.this.currentContentAssistIndex + 1) {
                                ConsolePage.this.currentContentAssistIndex = 0;
                            } else {
                                ConsolePage consolePage = ConsolePage.this;
                                consolePage.currentContentAssistIndex = consolePage.currentContentAssistIndex + 1;
                            }
                        }
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            return c;
        }

        public void refreshContent() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ConsolePage.this.defaultDisplay.setText(ConsolePage.this.defaultBuffer.toString());
                    ConsolePage.this.defaultDisplay.setSelection(ConsolePage.this.defaultBuffer.length() - 1);
                }
            });
        }

        public void clear() {
            this.defaultBuffer = new StringBuffer();
            this.refreshContent();
        }

        public int getListenerCategory() {
            return 0;
        }

        public void debug(String s) {
            if (ConsoleView.this.debugs) {
                this.defaultBuffer.append("[debug] " + s + "\n");
                this.refreshContent();
            }
        }

        public void error(String s) {
            if (ConsoleView.this.errors) {
                this.defaultBuffer.append("[error] " + s + "\n");
                this.refreshContent();
            }
        }

        public void fatal(String s) {
            this.defaultBuffer.append("[fatal] " + s + "\n");
            this.refreshContent();
        }

        public void info(String s) {
            if (ConsoleView.this.infos) {
                this.defaultBuffer.append("[info] " + s + "\n");
                this.refreshContent();
            }
        }

        public void init(VPMProperties p) {
        }

        public void message(int level, String msg, Throwable cause) {
            this.message(level, msg);
            this.printStackTrace(cause);
        }

        public void message(int level, String msg) {
            this.defaultBuffer.append("[message (" + level + ")] " + msg + "\n");
            this.refreshContent();
        }

        public void printStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.defaultBuffer.append("[exception] stack trace follows for: " + t.getClass().getCanonicalName() + ": " + t.getMessage() + "\n");
            this.defaultBuffer.append(sw.getBuffer());
            this.refreshContent();
        }

        public void setLevel(int l) {
        }

        public void warning(String s) {
            if (ConsoleView.this.warnings) {
                this.defaultBuffer.append("[warning] " + s + "\n");
                this.refreshContent();
            }
        }
    }
}

