/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console;

import java.awt.Dimension;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SimpleBorderLayout
extends Layout {
    public static final Integer CENTER = 0;
    public static final Integer EAST = 1;
    public static final Integer NORTH = 2;
    public static final Integer SOUTH = 3;
    public static final Integer WEST = 4;
    private Control centerElem;
    private Control eElem;
    private Control nElem;
    private Control sElem;
    private Control wElem;

    protected Point getPreferredSize(Control control, int wHint, int hHint, boolean changed) {
        Dimension dim = (Dimension)control.getData("preferredSize");
        if (dim != null) {
            return new Point(dim.width, dim.height);
        }
        return control.computeSize(wHint, hHint, changed);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point pref;
        this.getChildLayout(composite);
        Point base = new Point(0, 0);
        if (this.sElem != null) {
            pref = this.getPreferredSize(this.sElem, wHint, -1, flushCache);
            base.y += pref.y;
        }
        if (this.nElem != null) {
            pref = this.getPreferredSize(this.nElem, wHint, -1, flushCache);
            base.y += pref.y;
        }
        if (this.eElem != null) {
            pref = this.getPreferredSize(this.eElem, -1, hHint, flushCache);
            base.x += pref.x;
        }
        if (this.wElem != null) {
            pref = this.getPreferredSize(this.wElem, -1, hHint, flushCache);
            base.x += pref.x;
        }
        if (this.centerElem != null) {
            pref = this.getPreferredSize(this.centerElem, wHint, hHint, flushCache);
            base.x += pref.x;
            base.y += pref.y;
        }
        return base;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Point preferredSize;
        this.getChildLayout(composite);
        Rectangle bounds = composite.getClientArea();
        int t = bounds.y;
        int b = bounds.y + bounds.height;
        int l = bounds.x;
        int r = bounds.x + bounds.width;
        if (this.nElem != null) {
            preferredSize = this.getPreferredSize(this.nElem, bounds.width, -1, flushCache);
            this.nElem.setBounds(l, t, r - l, preferredSize.y);
            t += preferredSize.y;
        }
        if (this.sElem != null) {
            preferredSize = this.getPreferredSize(this.sElem, bounds.width, -1, flushCache);
            this.sElem.setBounds(l, b - preferredSize.y, r - l, preferredSize.y);
            b -= preferredSize.y;
        }
        if (this.wElem != null) {
            preferredSize = this.getPreferredSize(this.wElem, -1, b - t, flushCache);
            this.wElem.setBounds(l, t, preferredSize.x, b - t);
            l += preferredSize.x;
        }
        if (this.eElem != null) {
            preferredSize = this.getPreferredSize(this.eElem, -1, b - t, flushCache);
            this.eElem.setBounds(r - preferredSize.x, t, preferredSize.x, b - t);
            r -= preferredSize.x;
        }
        if (this.centerElem != null) {
            this.centerElem.setBounds(l, t, r - l, b - t);
        }
    }

    private void getChildLayout(Composite composite) {
        this.centerElem = null;
        this.wElem = null;
        this.eElem = null;
        this.sElem = null;
        this.nElem = null;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Integer layoutData = (Integer)children[i].getLayoutData();
            switch (layoutData) {
                default: {
                    this.centerElem = children[i];
                    break;
                }
                case 1: {
                    this.eElem = children[i];
                    break;
                }
                case 2: {
                    this.nElem = children[i];
                    break;
                }
                case 3: {
                    this.sElem = children[i];
                    break;
                }
                case 4: {
                    this.wElem = children[i];
                }
            }
            ++i;
        }
    }
}

