/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProviderFactory;
import org.eclipse.viatra2.frameworkgui.views.console.commands.ParsedCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutor {
    private static Map<String, List<String>> historyMap = new HashMap<String, List<String>>();

    public static List<String> getCommandHistory(IFramework fw) {
        return historyMap.get(fw.getId());
    }

    public static void storeCommand(IFramework fw, String raw) {
        List<String> history = historyMap.get(fw.getId());
        if (history == null) {
            history = new ArrayList<String>();
            historyMap.put(fw.getId(), history);
        }
        history.add(raw);
    }

    public static String getCommandAtBackwardIndex(IFramework fw, int ix) {
        List<String> history = historyMap.get(fw.getId());
        if (history != null) {
            try {
                return history.get(history.size() - ix);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    public static void clearCommandHistory(IFramework fw) {
        List<String> history = historyMap.get(fw.getId());
        if (history != null) {
            history.clear();
        }
    }

    public static ParsedCommand getParsedCommand(String raw) {
        String cmd_name = "";
        ArrayList<String> params = new ArrayList<String>();
        if (raw.indexOf("(") > 0 && raw.indexOf(")") > 0) {
            cmd_name = raw.substring(0, raw.indexOf("(")).trim().toLowerCase();
            try {
                String[] raw_params;
                String[] stringArray = raw_params = raw.substring(raw.indexOf("(") + 1, raw.lastIndexOf(")")).split(",");
                int n = raw_params.length;
                int n2 = 0;
                while (n2 < n) {
                    String rp = stringArray[n2];
                    params.add(rp.toString().trim());
                    ++n2;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            cmd_name = raw.trim().toLowerCase();
        }
        ParsedCommand c = new ParsedCommand();
        c.cmdName = cmd_name;
        c.params = params;
        c.isValid = true;
        return c;
    }

    public static IVIATRAConsoleCommandProvider getCommandByName(IFramework fw, String name) {
        for (IVIATRAConsoleCommandProviderFactory f : FrameworkGUIPlugin.getDefault().getCommandProviderFactories()) {
            for (IVIATRAConsoleCommandProvider cp : f.getProviders(fw)) {
                if (!cp.getClass().getSimpleName().toLowerCase().equals(name)) continue;
                return cp;
            }
        }
        return null;
    }

    public static List<IVIATRAConsoleCommandProvider> getCommandByNamePrefix(IFramework fw, String prefix) {
        ArrayList<IVIATRAConsoleCommandProvider> matches = new ArrayList<IVIATRAConsoleCommandProvider>();
        for (IVIATRAConsoleCommandProviderFactory f : FrameworkGUIPlugin.getDefault().getCommandProviderFactories()) {
            for (IVIATRAConsoleCommandProvider cp : f.getProviders(fw)) {
                if (!cp.getClass().getSimpleName().toLowerCase().startsWith(prefix)) continue;
                matches.add(cp);
            }
        }
        return matches;
    }

    public static boolean executeCommand(IFramework fw, ParsedCommand pcmd) {
        if (!pcmd.isValid) {
            return false;
        }
        boolean foundMatch = false;
        for (IVIATRAConsoleCommandProviderFactory f : FrameworkGUIPlugin.getDefault().getCommandProviderFactories()) {
            for (IVIATRAConsoleCommandProvider cp : f.getProviders(fw)) {
                if (!cp.getClass().getSimpleName().toLowerCase().equals(pcmd.cmdName)) continue;
                cp.executeCommand(fw, pcmd.params);
                foundMatch = true;
                break;
            }
            if (foundMatch) break;
        }
        return foundMatch;
    }
}

