/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.Map;
import org.eclipse.viatra2.framework.FrameworkException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.xform.TransformationExecutionHelper;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;

public abstract class AbstractRunnerCommand {
    protected void commenceRunning(IFramework fw, Object entrypoint, String paramStr, String epName, boolean undoable) {
        try {
            if (!fw.isRunnable(entrypoint)) {
                fw.getLogger().error("[RunRule] entrypoint " + epName + " is not runnable.");
                return;
            }
        }
        catch (FrameworkException e) {
            fw.getLogger().error("[RunRule] entrypoint " + epName + " is not runnable.");
            fw.getLogger().printStackTrace((Throwable)e);
            return;
        }
        Map<String, Object> params = TransformationExecutionHelper.parseParameters(paramStr);
        if (!TransformationExecutionHelper.checkParameterCompatibility(fw, entrypoint, params)) {
            fw.getLogger().error("[RunnerCommands] transformation parameters not compatible with machine.");
            fw.getLogger().info("[RunnerCommands] parsed parameters: " + params.toString());
            return;
        }
        if (entrypoint instanceof Machine) {
            TransformationExecutionHelper.runMachine(fw, (Machine)entrypoint, params, undoable);
        } else if (entrypoint instanceof Rule) {
            TransformationExecutionHelper.runRule(fw, (Rule)entrypoint, params, undoable);
        }
    }
}

