/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.List;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.xform.AbstractRunnerCommand;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMachine
extends AbstractRunnerCommand
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 2) {
            fw.getLogger().error("[RunMachine] Wrong number of parameters supplied.");
            return;
        }
        String machineFQN = parameters.get(0);
        Machine m = (Machine)fw.getMachineByFQN(machineFQN);
        if (m == null) {
            fw.getLogger().error("[RunMachine] machine " + machineFQN + " not found.");
            return;
        }
        this.commenceRunning(fw, m, parameters.get(1), m.getFqn(), false);
    }

    @Override
    public String getCommandSignature() {
        return "runmachine(machineFQN,parameterMappings)";
    }

    @Override
    public String getDescription() {
        return "Executes a GTASM Machine in a normal VIATRA2 transaction.";
    }

    @Override
    public String getHelpText() {
        return "Use runmachine(<<machine fqn>>,<<parametermapping>>) to execute a GTASM machine in a normal transaction.\nParameter mappings take the following syntax: <<parametername=value>> and are separated by ; characters.\nExample: runmachine(helloworld, target=John;message=Hello)";
    }
}

