/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.List;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.xform.AbstractRunnerCommand;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMachineUndoable
extends AbstractRunnerCommand
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 2) {
            fw.getLogger().error("[RunMachineUndoable] Wrong number of parameters supplied.");
            return;
        }
        String machineFQN = parameters.get(0);
        Machine m = (Machine)fw.getMachineByFQN(machineFQN);
        if (m == null) {
            fw.getLogger().error("[RunMachineUndoable] machine " + machineFQN + " not found.");
            return;
        }
        this.commenceRunning(fw, m, parameters.get(1), m.getFqn(), true);
    }

    @Override
    public String getCommandSignature() {
        return "runmachineundoable(machineFQN,parameterMappings)";
    }

    @Override
    public String getDescription() {
        return "Executes a GTASM Machine in an undoable VIATRA2 transaction.";
    }

    @Override
    public String getHelpText() {
        return "Use runmachineundoable(<<machine fqn>>,<<parametermapping>>) to execute a GTASM machine in an undoable transaction.\nParameter mappings take the following syntax: <<parametername=value>> and are separated by ; characters.\nExample: runmachineundoable(helloworld, target=John;message=Hello)";
    }
}

