/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.List;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.xform.AbstractRunnerCommand;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunRule
extends AbstractRunnerCommand
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 2) {
            fw.getLogger().error("[RunRule] Wrong number of parameters supplied.");
            return;
        }
        String ruleFQN = parameters.get(0);
        if (ruleFQN.indexOf(".") < 0) {
            fw.getLogger().error("[RunRule] rule FQN does not contain at least one dot (.)");
            return;
        }
        String ruleName = ruleFQN.substring(ruleFQN.lastIndexOf(".") + 1);
        if (ruleName.length() < 1) {
            fw.getLogger().error("[RunRule] rule name empty.");
            return;
        }
        String machineFQN = ruleFQN.substring(0, ruleFQN.lastIndexOf("."));
        Machine m = (Machine)fw.getMachineByFQN(machineFQN);
        if (m == null) {
            fw.getLogger().error("[RunRule] machine " + machineFQN + " not found.");
            return;
        }
        Rule entrypoint = null;
        for (Rule r : m.getAsmRuleDefinitions()) {
            if (!r.getName().equals(ruleName)) continue;
            entrypoint = r;
            break;
        }
        if (entrypoint == null) {
            fw.getLogger().error("[RunRule] rule " + ruleName + " not found.");
            return;
        }
        this.commenceRunning(fw, entrypoint, parameters.get(1), ruleName, false);
    }

    @Override
    public String getCommandSignature() {
        return "runrule(ruleFQN,parameterMappings)";
    }

    @Override
    public String getDescription() {
        return "Executes a GTASM Rule in a normal VIATRA2 transaction.";
    }

    @Override
    public String getHelpText() {
        return "Use runrule(<<rule fqn>>,<<parametermapping>>) to execute a GTASM rule in a normal transaction.\nParameter mappings take the following syntax: <<parametername=value>> and are separated by ; characters.\nExample: runrule(helloworld.sayhello, target=John;message=Hello)";
    }
}

