/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.errors.VPMRuntimeControlledException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.FrameworkException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.interpreters.IProgressReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationExecutionHelper {
    public static Map<String, Object> parseParameters(String paramStr) {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        String[] stringArray = paramStr.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.length() > 0 && entry.indexOf("=") > -1) {
                String key = entry.substring(0, entry.indexOf("="));
                String value = entry.substring(entry.indexOf("=") + 1);
                ret.put(key, TransformationExecutionHelper.convertToPassableType(value));
            }
            ++n2;
        }
        return ret;
    }

    public static boolean checkParameterCompatibility(IFramework fw, Object m, Map<String, Object> params) {
        String[] paramNames;
        try {
            paramNames = fw.getEntrypointParameters(m);
        }
        catch (FrameworkException frameworkException) {
            return false;
        }
        boolean ret = true;
        if (paramNames != null && params != null) {
            String[] stringArray = paramNames;
            int n = paramNames.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                ret &= params.get(param) != null;
                ++n2;
            }
        }
        return ret;
    }

    public static Object convertToPassableType(String val) {
        Object o = val;
        try {
            o = new Double(Double.parseDouble(val));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            o = new Integer(Integer.parseInt(val));
        }
        catch (NumberFormatException numberFormatException) {}
        return o;
    }

    private static IRunnableWithProgress createRunnable(final IFramework fw, final Object entryPoint, final Map<String, Object> params, final boolean undoable) {
        return new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                long start = 0L;
                String transID = "";
                try {
                    try {
                        monitor.beginTask("VIATRA2 Transformation executing", 1000000);
                        start = System.currentTimeMillis();
                        transID = undoable ? fw.getTopmodel().getTransactionManager().beginUndoableTransaction((Object)Boolean.TRUE) : fw.getTopmodel().getTransactionManager().beginTransaction((Object)Boolean.TRUE);
                        monitor.worked(2);
                        fw.runEntrypoint(entryPoint, params, new IProgressReport(){

                            public void progress(int indicator) {
                                monitor.worked(indicator);
                            }
                        });
                    }
                    catch (VPMRuntimeControlledException rex) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"VIATRA2 R3", (String)(String.valueOf(rex.getMessage()) + " (see the Error Log view for details)"));
                            }
                        });
                        fw.getTopmodel().getTransactionManager().commitTransaction();
                        long stop = System.currentTimeMillis();
                        monitor.done();
                        fw.getLogger().info("Transformation engine ran for " + (stop - start) + " milliseconds.");
                        if (undoable) {
                            fw.getLogger().info("Transformation transaction ID: " + transID);
                        }
                    }
                    catch (VPMRuntimeException rex) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"VIATRA2 R3", (String)(String.valueOf(rex.getMessage()) + " (see the Error Log view for details)"));
                            }
                        });
                        fw.getTopmodel().getTransactionManager().commitTransaction();
                        long stop = System.currentTimeMillis();
                        monitor.done();
                        fw.getLogger().info("Transformation engine ran for " + (stop - start) + " milliseconds.");
                        if (undoable) {
                            fw.getLogger().info("Transformation transaction ID: " + transID);
                        }
                    }
                }
                finally {
                    fw.getTopmodel().getTransactionManager().commitTransaction();
                    long stop = System.currentTimeMillis();
                    monitor.done();
                    fw.getLogger().info("Transformation engine ran for " + (stop - start) + " milliseconds.");
                    if (undoable) {
                        fw.getLogger().info("Transformation transaction ID: " + transID);
                    }
                }
            }
        };
    }

    public static void runRule(IFramework fw, Rule r, Map<String, Object> params, boolean undoable) {
        FrameworkGUIPlugin.runAsLongTransaction(TransformationExecutionHelper.createRunnable(fw, r, params, undoable), "VIATRA2 Transformation: " + r.getFqn(), fw);
    }

    public static void runMachine(IFramework fw, Machine m, Map<String, Object> params, boolean undoable) {
        FrameworkGUIPlugin.runAsLongTransaction(TransformationExecutionHelper.createRunnable(fw, m, params, undoable), "VIATRA2 Transformation: " + m.getFqn(), fw);
    }
}

