/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.List;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoTransaction
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 1) {
            fw.getLogger().error("[UndoTransaction] Wrong number of parameters supplied. Expected: 1, received: " + parameters.size());
            return;
        }
        String transID = parameters.get(0);
        fw.getTopmodel().getTransactionManager().undoTransaction(transID);
    }

    @Override
    public String getCommandSignature() {
        return "undotransaction(transactionID)";
    }

    @Override
    public String getDescription() {
        return "Rolls back the VIATRA2 modelspace to the state before the transaction with the given ID was executed.";
    }

    @Override
    public String getHelpText() {
        return "Use undotransaction(<<transactionID>>) to undo the effects of a previously executed undoable transaction.\nThis command " + this.getDescription();
    }
}

