--
-- The VTCL Keyword Lexer
-- Copyright (c) 2007 OptXware Research and Development LLC.
-- All rights reserved.   This program and the accompanying materials
-- are made available under the terms of the Eclipse Public License v1.0
-- which accompanies this distribution, and is available at
-- http://www.eclipse.org/legal/epl-v10.html
--
-- Contributors:
--   Daniel Varro - Initial API and implementation

%Options fp=VTCLKWLexer,prefix=Char_
%options escape=$
%options package=org.eclipse.viatra2.lpgparser
--%options dat-directory=./hu/optxware/viatra/lpgparser
%options template=KeyWordTemplateD.g
%options export_terminals=("VTCLParsersym.java", "TK_")
-- %options noserialize

$Notice
	/./**
 *
 * Copyright (c) 2007 OptXware Research and Development LLC.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Daniel Varro - Initial API and implementation
 *
 * This file was generated automatically based upon the VTCL LPG Lexer
 * VTCLKWLexer.g (and btVTCLParserTemplateD.g)
 */
	./
$End

$Define

	--
	-- Definition of macros used in the template
	--
--	$action_class /.$file_prefix./
--	$eof_char /.Char_EOF./

$End


$Include
    VTCLKWLexerMap.g
$End

$Export
    namespace
    import
    machine
    pattern
    or
    neg
    find
    check
    supertypeOf
    subtypeOf
    typeOf
    instanceOf
    gtrule
    precondition
    postcondition
    action
    apply
    xor
    asmfunction
    rule
    out
    inout
    skip
    fail
    call
    update
    print
    println
    log
    debug
    info
    warning
    error
    fatal
    seq
    parallel
    random
    let
    in
    below
    choose
    forall
    with 
    do
    iterate
    if
    try
    else
    when
    new
    delete
    changed
    -- Can I include the next two items here?
    delete_content
    move_content
    copy
    copy_boundary_edges
    skip_boundary_edges
    move
    rename
    setValue
    setFrom
    setTo
    setMultiplicity
    setAggregation
    setInverse
    shareable
    -- Built-in constants
    undef
    true
    false
    one_to_one
    one_to_many
    many_to_one
    many_to_many
    -- not keywords but treated as keywords by LPG
    ref
    fqn
    name
    value
    source
    target
    multiplicity
    aggregation
    inverse
    toBoolean
    toString
    toInteger
    toDouble
    toMultiplicity
$End

$Terminals
    a    b    c    d    e    f    g    h    i    j    k    l    m
    n    o    p    q    r    s    t    u    v    w    x    y    z
    _
    A    B    C    D    E    F    G    H    I    J    K    L    M
    N    O    P    Q    R    S    T    U    V    W    X    Y    Z
$End

--$Eof
--	EOF
--$End

$Start
    KeyWord
$End

$Rules

-- The Goal for the parser is a single Keyword

    KeyWord ::= n a m e s p a c e
        /.$BeginAction
            $setResult($_namespace);
          $EndAction
        ./

              | i m p o r t
        /.$BeginAction
            $setResult($_import);
          $EndAction
        ./

              | m a c h i n e
        /.$BeginAction
            $setResult($_machine);
          $EndAction
        ./

              | p a t t e r n
        /.$BeginAction
            $setResult($_pattern);
          $EndAction
        ./

              | o r
        /.$BeginAction
            $setResult($_or);
          $EndAction
        ./

              | n e g
        /.$BeginAction
            $setResult($_neg);
          $EndAction
        ./

              | f i n d
        /.$BeginAction
            $setResult($_find);
          $EndAction
        ./

              | c h e c k 
        /.$BeginAction
            $setResult($_check);
          $EndAction
        ./

              | s u p e r t y p e O f
        /.$BeginAction
            $setResult($_supertypeOf);
          $EndAction
        ./

              | s u b t y p e O f
        /.$BeginAction
            $setResult($_subtypeOf);
          $EndAction
        ./

              | t y p e O f
        /.$BeginAction
            $setResult($_typeOf);
          $EndAction
        ./

              | i n s t a n c e O f
        /.$BeginAction
            $setResult($_instanceOf);
          $EndAction
        ./

              | g t r u l e
        /.$BeginAction
            $setResult($_gtrule);
          $EndAction
        ./

              | p r e c o n d i t i o n
        /.$BeginAction
            $setResult($_precondition);
          $EndAction
        ./

              | p o s t c o n d i t i o n
        /.$BeginAction
            $setResult($_postcondition);
          $EndAction
        ./

              | a c t i o n
        /.$BeginAction
            $setResult($_action);
          $EndAction
        ./

              | a p p l y
        /.$BeginAction
            $setResult($_apply);
          $EndAction
        ./

              | x o r
        /.$BeginAction
            $setResult($_xor);
          $EndAction
        ./

              | a s m f u n c t i o n
        /.$BeginAction
            $setResult($_asmfunction);
          $EndAction
        ./

              | r u l e
        /.$BeginAction
            $setResult($_rule);
          $EndAction
        ./

              | o u t 
        /.$BeginAction
            $setResult($_out);
          $EndAction
        ./

              | i n o u t 
        /.$BeginAction
            $setResult($_inout);
          $EndAction
        ./


              | f a i l 
        /.$BeginAction
            $setResult($_fail);
          $EndAction
        ./

              | c a l l  
        /.$BeginAction
            $setResult($_call);
          $EndAction
        ./

              | u p d a t e  
        /.$BeginAction
            $setResult($_update);
          $EndAction
        ./

              | p r i n t  
        /.$BeginAction
            $setResult($_print);
          $EndAction
        ./

              | p r i n t l n  
        /.$BeginAction
            $setResult($_println);
          $EndAction
        ./

              | l o g
        /.$BeginAction
            $setResult($_log);
          $EndAction
        ./

              | d e b u g
        /.$BeginAction
            $setResult($_debug);
          $EndAction
        ./

              | i n f o 
        /.$BeginAction
            $setResult($_info);
          $EndAction
        ./

              | w a r n i n g
        /.$BeginAction
            $setResult($_warning);
          $EndAction
        ./

              | e r r o r
        /.$BeginAction
            $setResult($_error);
          $EndAction
        ./

              | f a t a l
        /.$BeginAction
            $setResult($_fatal);
          $EndAction
        ./

              | s e q
        /.$BeginAction
            $setResult($_seq);
          $EndAction
        ./

              | s h a r e a b l e
        /.$BeginAction
            $setResult($_shareable);
          $EndAction
        ./
              | p a r a l l e l
        /.$BeginAction
            $setResult($_parallel);
          $EndAction
        ./

              | r a n d o m
        /.$BeginAction
            $setResult($_random);
          $EndAction
        ./

              | l e t 
        /.$BeginAction
            $setResult($_let);
          $EndAction
        ./

              | i n  
        /.$BeginAction
            $setResult($_in);
          $EndAction
        ./

              | b e l o w
        /.$BeginAction
            $setResult($_below);
          $EndAction
        ./

              | c h o o s e
        /.$BeginAction
            $setResult($_choose);
          $EndAction
        ./

              | f o r a l l 
        /.$BeginAction
            $setResult($_forall);
          $EndAction
        ./

              | w i t h 
        /.$BeginAction
            $setResult($_with);
          $EndAction
        ./

              | d o 
        /.$BeginAction
            $setResult($_do);
          $EndAction
        ./

              | i t e r a t e 
        /.$BeginAction
            $setResult($_iterate);
          $EndAction
        ./

              | i f
        /.$BeginAction
            $setResult($_if);
          $EndAction
        ./

              | t r y
        /.$BeginAction
            $setResult($_try);
          $EndAction
        ./

              | e l s e
        /.$BeginAction
            $setResult($_else);
          $EndAction
        ./
        
              | w h e n
        /.$BeginAction
            $setResult($_when);
          $EndAction
        ./

              | c h a n g e d
        /.$BeginAction
            $setResult($_changed);
          $EndAction
        ./

              | n e w
        /.$BeginAction
            $setResult($_new);
          $EndAction
        ./

              | d e l e t e _ c o n t e n t
        /.$BeginAction
            $setResult($_delete_content);
          $EndAction
        ./

              | m o v e _ c o n t e n t
        /.$BeginAction
            $setResult($_move_content);
          $EndAction
        ./

              | s k i p _ b o u n d a r y _ e d g e s
        /.$BeginAction
            $setResult($_skip_boundary_edges);
          $EndAction
        ./

              | c o p y _ b o u n d a r y _ e d g e s
        /.$BeginAction
            $setResult($_copy_boundary_edges);
          $EndAction
        ./

              | s k i p
        /.$BeginAction
            $setResult($_skip);
          $EndAction
        ./

              | d e l e t e
        /.$BeginAction
            $setResult($_delete);
          $EndAction
        ./

              | c o p y 
        /.$BeginAction
            $setResult($_copy);
          $EndAction
        ./

              | m o v e  
        /.$BeginAction
            $setResult($_move);
          $EndAction
        ./

              | r e n a m e
        /.$BeginAction
            $setResult($_rename);
          $EndAction
        ./

	          | s e t V a l u e
		/.$BeginAction
            $setResult($_setValue);
          $EndAction
        ./

              | s e t F r o m
        /.$BeginAction
            $setResult($_setFrom);
          $EndAction
        ./

              | s e t T o 
        /.$BeginAction
            $setResult($_setTo);
          $EndAction
        ./

              | s e t M u l t i p l i c i t y
        /.$BeginAction
            $setResult($_setMultiplicity);
          $EndAction
        ./

              | s e t A g g r e g a t i o n
        /.$BeginAction
            $setResult($_setAggregation);
          $EndAction
        ./

              | s e t I n v e r s e
        /.$BeginAction
            $setResult($_setInverse);
          $EndAction
        ./

              | u n d e f 
        /.$BeginAction
            $setResult($_undef);
          $EndAction
        ./

              | t r u e
        /.$BeginAction
            $setResult($_true);
          $EndAction
        ./

              | f a l s e
        /.$BeginAction
            $setResult($_false);
          $EndAction
        ./

              | o n e _ t o _ o n e
        /.$BeginAction
            $setResult($_one_to_one);
          $EndAction
        ./

              | o n e _ t o _ m a n y
        /.$BeginAction
            $setResult($_one_to_many);
          $EndAction
        ./

              | m a n y _ t o _ o n e
        /.$BeginAction
            $setResult($_many_to_one);
          $EndAction
        ./

              | m a n y _ t o _ m a n y
        /.$BeginAction
            $setResult($_many_to_many);
          $EndAction
        ./


              | v a l u e 
        /.$BeginAction
            $setResult($_value);
          $EndAction
        ./

              | n a m e
        /.$BeginAction
            $setResult($_name);
          $EndAction
        ./

              | f q n 
        /.$BeginAction
            $setResult($_fqn);
          $EndAction
        ./

              | r e f 
        /.$BeginAction
            $setResult($_ref);
          $EndAction
        ./

              | s o u r c e 
        /.$BeginAction
            $setResult($_source);
          $EndAction
        ./

              | t a r g e t  
        /.$BeginAction
            $setResult($_target);
          $EndAction
        ./

              | m u l t i p l i c i t y 
        /.$BeginAction
            $setResult($_multiplicity);
          $EndAction
        ./

              | a g g r e g a t i o n
        /.$BeginAction
            $setResult($_aggregation);
          $EndAction
        ./

              | i n v e r s e
        /.$BeginAction
            $setResult($_inverse);
          $EndAction
        ./

              | t o S t r i n g 
        /.$BeginAction
            $setResult($_toString);
          $EndAction
        ./

              | t o I n t e g e r  
        /.$BeginAction
            $setResult($_toInteger);
          $EndAction
        ./

              | t o B o o l e a n  
        /.$BeginAction
            $setResult($_toBoolean);
          $EndAction
        ./

              | t o D o u b l e  
        /.$BeginAction
            $setResult($_toDouble);
          $EndAction
        ./

              | t o M u l t i p l i c i t y  
        /.$BeginAction
            $setResult($_toMultiplicity);
          $EndAction
        ./
$End
