--
-- The VTCL Parser
--
-- Copyright (c) 2007-2009 OptXware Research and Development LLC.
-- All rights reserved.   This program and the accompanying materials
-- are made available under the terms of the Eclipse Public License v1.0
-- which accompanies this distribution, and is available at
-- http://www.eclipse.org/legal/epl-v10.html
--
-- Contributors:
--   Daniel Varro - Initial API and implementation

%options escape=$
%options fp=VTCLParser,prefix=TK_
%options package=org.eclipse.viatra2.lpgparser
%options template=btVTCLParserTemplateD.g
--%options template=dtVtclParserTemplateD.g
%options import_terminals=VTCLLexer.g
%options ast_directory=./ast,automatic_ast=toplevel
%options parent-saved
%options variables=nt
%options visitor=default
%options shift-default
--%options first
--%Options follow
--%options automatic_ast
%options ast_type=ASTNode
--%options var=nt
--%options la=2
--%options error-maps
--%options single-productions
--%options scopes
--%options action=("*.java", "/.", "./")
--%options action=("VTCLParser.java", "/:", ":/")
%options ParseTable=lpg.lpgjavaruntime.ParseTable
%options verbose


$Terminals
    IDENTIFIER

    namespace import machine pattern or neg find check supertypeOf subtypeOf
    typeOf instanceOf gtrule precondition postcondition action apply xor
    asmfunction rule skip fail call update print println log debug info warning
    error fatal seq random let in below choose forall with do iterate if try else
    new delete delete_content move_content copy copy_boundary_edges
    skip_boundary_edges move rename setValue setFrom setTo setMultiplicity
    setAggregation setInverse undef true false one_to_one one_to_many
    many_to_one many_to_many ref fqn name value source target multiplicity
    aggregation inverse toBoolean toString toInteger toDouble toMultiplicity out inout
    parallel changed when shareable

    IntegerLiteral        
--    LongLiteral           
    FloatingPointLiteral  
    DoubleLiteral         
    NameLiteral      -- the usual
    AnnotationLiteral -- @name
    StringLiteral         -- the usual
	UpperCaseLiteral  -- Starts with an uppercase letter
	DummyVariableLiteral -- Starts with an underscore '_'
	DecimalIntegerLiteral

--    PLUS_PLUS                  ::= '++'
--    MINUS_MINUS                ::= '--'
    EQUAL_EQUAL                ::= '=='
    LESS_EQUAL                 ::= '<='
    GREATER_EQUAL              ::= '>='
    NOT_EQUAL                  ::= '!='
    NONINJECTIVE               ::= '=/='
--    LEFT_SHIFT                 ::= '<<'
--    RIGHT_SHIFT                ::= '>>'
--    UNSIGNED_RIGHT_SHIFT       ::= '>>>'
--    PLUS_EQUAL                 ::= '+='
--    MINUS_EQUAL                ::= '-='
--    MULTIPLY_EQUAL             ::= '*='
--    DIVIDE_EQUAL               ::= '/='
--    AND_EQUAL                  ::= '&='
--    OR_EQUAL                   ::= '|='
--    XOR_EQUAL                  ::= '^='
--    REMAINDER_EQUAL            ::= '%='
--    LEFT_SHIFT_EQUAL           ::= '<<='
--    RIGHT_SHIFT_EQUAL          ::= '>>='
--    UNSIGNED_RIGHT_SHIFT_EQUAL ::= '>>>='
    OR_OR                      ::= '||'
    AND_AND                    ::= '&&'
    RIGHTARROW                 ::= '->'

    PLUS      ::= '+'
    MINUS     ::= '-'
    NOT       ::= '!'
    REMAINDER ::= '%'
    XOR       ::= '^'
    AND       ::= '&'
    MULTIPLY  ::= '*'
    OR        ::= '|'
    TWIDDLE   ::= '~'
    DIVIDE    ::= '/'
    GREATER   ::= '>'
    LESS      ::= '<'
    LPAREN    ::= '('
    RPAREN    ::= ')'
    LBRACE    ::= '{'
    RBRACE    ::= '}'
    LBRACKET  ::= '['
    RBRACKET  ::= ']'
    SEMICOLON ::= ';'
    HASHMARK  ::= '#'
    QUESTION  ::= '?'
    COLON     ::= ':'
    COMMA     ::= ','
    DOT       ::= '.'
    EQUAL     ::= '='
    
$End

$Notice
	/./**
 * Copyright (c) 2007 - 2009 OptXware Research and Development LLC.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Daniel Varro - Initial API and implementation
 *
 * This file was generated automatically based upon the VTCL LPG Parser
 * VTCLParser.g 
 */
	./
$End

$Define
--	$action_class /.$file_prefix./
--	$prs_stream_class /.PrsStream./
--
    $BeginAstAction
    /.
    	void initialize()
        {./

    $EndAstAction 
    /.  }
    ./
$End

--$EOL
--    ;
--$End

$ERROR
    ERROR_TOKEN
$End

$Start
    VTCLFile
$End

--$Headers
--$End
   
$Rules
--------------------------------------------------------------------------------
-- Sec. 5.1.	
--------------------------------------------------------------------------------

	VTCLFile ::= NamespaceDefAST NamespaceImportsAST GTASMDefAST

	NamespaceDefAST ::= $empty
                   | namespace QualifiedTypeNameAST SEMICOLON
--                   | ERROR_TOKEN 
--        /.$BeginAstAction
--                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
--          $EndAstAction
--        ./	

	NamespaceImportsAST ::= $empty 
                       | NamespaceImportsAST NamespaceImportAST

	NamespaceImportAST ::= import QualifiedTypeNameAST SEMICOLON
	                  | ERROR_TOKEN
        /.$BeginAstAction
                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
          $EndAstAction
        ./	
	GTASMDefAST ::= OptAnnotationsAST machine TypeNameAST LBRACE MachineContentsAST RBRACE

-- MachineContentsAST is added as a non-terminal to reduce look-ahead	
	MachineContentsAST ::= MachineContentAST
	                  | MachineContentsAST MachineContentAST
	                  
	MachineContentAST ::= GraphPatternDefAST 	                  
	                 | GTRuleDefAST
	                 | AsmFunctionDefAST
	                 | AsmRuleDefAST
	                 | ERROR_TOKEN
        /.$BeginAstAction
                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
          $EndAstAction
        ./	

--------------------------------------------------------------------------------
-- Sec. 5.2.	
--------------------------------------------------------------------------------

	GraphPatternDefAST ::= OptAnnotationsAST OptShareableDefAST pattern TypeNameAST FormalParameterDefAST EQUAL PatternBodiesAST
--	                  | ERROR_TOKEN

  OptShareableDefAST ::= $empty | shareable
             
-- PatternBodiesAST is added as a non-terminal to reduce look-ahead	
	PatternBodiesAST ::= PatternBodyAST
                    | PatternBodiesAST or PatternBodyAST

	
	PatternBodyAST ::= LBRACE PatternBodyContentsAST RBRACE
	
	PatternBodyContentsAST ::= $empty --PatternBodyContentAST 
	                      | PatternBodyContentsAST PatternBodyContentDefAST
--	                      | ERROR_TOKEN

	PatternBodyContentDefAST ::= PatternBodyContentAST SEMICOLON
	                        | neg GraphPatternDefAST

	PatternBodyContentAST ::= LocalPatternBodyElementAST
	                        | PatternCompositionAST
	                        | NegativePatternAST
	                        | PatternVariableAssignmentAST
	                        | CheckConditionAST
	                        | NonInjectivityConstraintAST
	                        | ERROR_TOKEN

	LocalPatternBodyElementAST ::= ModelElementAST
	                             | RelationshipAST
--	                             | ERROR_TOKEN

	NegativePatternAST ::= neg PatternCompositionAST 
--	                     | neg GraphPatternDefAST
	
	PatternCompositionAST ::= find QualifiedTypeNameAST ActualPatternParameterDefAST OptMatchCountAST --SEMICOLON


	PatternVariableAssignmentAST ::= PatternVariableRefAST EQUAL PatternVariableRefAST --SEMICOLON
	
	NonInjectivityConstraintAST ::= PatternVariableRefAST NONINJECTIVE PatternVariableRefAST 
	
	CheckConditionAST ::= check LPAREN LogicalTermAST RPAREN --SEMICOLON
	
	OptMatchCountAST ::= $empty | HASHMARK CounterVariableAST 
	
--    PatternVariableAST ::= VariableAST 
    PatternVariableDefAST ::= UpperCaseLiteral 
    PatternVariableRefAST ::= UpperCaseLiteral 
    PatternVariableDefRefAST ::= UpperCaseLiteral | DummyVariableLiteral

	  CounterVariableAST ::= UpperCaseLiteral
     
    GraphPatternCallAST ::= find QualifiedTypeNameAST ActualParameterDefAST OptMatchCountAST
    
--------------------------------------------------------------------------------
-- Sec. 5.2.2 Entity Definition
--------------------------------------------------------------------------------

	ModelElementAST ::= EntityAST | RelationAST

-- Entity values are not allowed 
--	EntityAST ::= QualifiedTypeNameAST EntityBody EntityValueOptAST ContainmentConstraintOptAST SEMICOLON
	EntityAST ::= QualifiedTypeNameAST EntityBody ContainmentConstraintOptAST --SEMICOLON	

	EntityBody ::= LPAREN PatternVariableDefRefAST RPAREN 

--	EntityValueOptAST ::= $empty |  RIGHTARROW ArithmeticTermAST	
	
--------------------------------------------------------------------------------
-- Sec. 5.2.3 Relation Definition
--------------------------------------------------------------------------------
	
	RelationAST ::= QualifiedTypeNameAST RelationBodyAST --SEMICOLON

	RelationBodyAST ::= LPAREN PatternVariableDefRefAST COMMA PatternVariableRefAST COMMA PatternVariableRefAST RPAREN 
	
--------------------------------------------------------------------------------
-- Sec. 5.2.4 Relationship Definition
--------------------------------------------------------------------------------
    
    RelationshipAST ::= InheritanceAST | InstantiationAST
    
    InheritanceAST ::= supertypeOf RelationshipBodyAST --SEMICOLON
                     | subtypeOf RelationshipBodyAST --SEMICOLON
	
	InstantiationAST ::= typeOf RelationshipBodyAST --SEMICOLON
	                   | instanceOf RelationshipBodyAST --SEMICOLON

	RelationshipBodyAST ::= LPAREN PatternVariableRefAST COMMA PatternVariableRefAST RPAREN
	
--------------------------------------------------------------------------------
-- Sec. 5.3 Graph Transformation
--------------------------------------------------------------------------------

	GTRuleDefAST ::= OptAnnotationsAST gtrule TypeNameAST DirectedFormalParameterDefAST EQUAL GTRuleBodyAST 

	GTRuleBodyAST ::= LBRACE PreconditionDefAST PostconditionOptAST ActionOptAST RBRACE
	               | ERROR_TOKEN
        /.$BeginAstAction
                   //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
          $EndAstAction
        ./	
	
	PreconditionDefAST ::= precondition GraphPatternDefAST
	                     | precondition PatternCompositionAST

	PostconditionOptAST ::= $empty 
	                      | postcondition GraphPatternDefAST
	                      | postcondition PatternCompositionAST
	                
	ActionOptAST ::= $empty 
				   | action LBRACE AsmRulesAST RBRACE  	                	               
	
	GTRuleCallAST ::= apply QualifiedTypeNameAST ActualParameterDefAST 

--------------------------------------------------------------------------------
-- Sec. 5.4	Terms and Formulas
--------------------------------------------------------------------------------
--	TermAST ::= LogicalTermAST 
--	       | ArithmeticTermAST

--------------------------------------------------------------------------------
-- Sec. 5.4.1 Logical Terms 
--------------------------------------------------------------------------------
	LogicalTermAST ::= LogicalAndTermAST 
	                 | LogicalTermAST OR_OR LogicalAndTermAST
	                 | LogicalTermAST xor LogicalAndTermAST	       

	LogicalAndTermAST ::= EqualityTermAST 
	                    | LogicalAndTermAST AND_AND EqualityTermAST
	                 
    EqualityTermAST ::= RelationalTermAST
                     | EqualityTermAST EQUAL_EQUAL RelationalTermAST
                     | EqualityTermAST NOT_EQUAL RelationalTermAST
    
    RelationalTermAST ::= ArithmeticTermAST  
	                 | RelationalTermAST RelationalOpAST ArithmeticTermAST
                     	                 

	RelationalOpAST$RelationalOpAST ::= LESS | GREATER | LESS_EQUAL | GREATER_EQUAL   

--	LogicalTermAST ::= LogicalAndTermAST 
--	                 | LogicalTermAST OR_OR LogicalAndTermAST
--	                 | LogicalTermAST xor LogicalAndTermAST	       

--	LogicalAndTermAST ::= BaseLogicalTermAST 
--	                    | LogicalAndTermAST AND_AND BaseLogicalTermAST
	                 
--	BaseLogicalTermAST ::= NOT BaseLogicalTermAST
--	                     | LPAREN LogicalTermAST RPAREN
--	                     | BooleanConstantAST 
--	                     | ArithmeticTermAST RelationalOpAST ArithmeticTermAST
--	                     | GraphPatternCallAST
----	                     | BaseLogicalTermAST EQUAL_EQUAL BaseLogicalTermAST
----	                     | BaseLogicalTermAST NOT_EQUAL BaseLogicalTermAST
	                 
--	RelationalOpAST$RelationalOpAST ::= EQUAL_EQUAL | LESS | GREATER 
--	                  | LESS_EQUAL | GREATER_EQUAL | NOT_EQUAL  



--------------------------------------------------------------------------------
-- Sec. 5.4.2 Arithmetic Terms 
--------------------------------------------------------------------------------

	ArithmeticTermAST ::= MultArithmeticTermAST 
	                    | ArithmeticTermAST PLUS MultArithmeticTermAST
	                    | ArithmeticTermAST MINUS MultArithmeticTermAST
	
	MultArithmeticTermAST ::= UnaryArithmeticTermAST
	                        | MultArithmeticTermAST MULTIPLY UnaryArithmeticTermAST
	                        | MultArithmeticTermAST DIVIDE UnaryArithmeticTermAST
	                        | MultArithmeticTermAST REMAINDER UnaryArithmeticTermAST
	
	UnaryArithmeticTermAST ::= BaseArithmeticTermAST  --NavigationTermAST
	                        | MINUS BaseArithmeticTermAST  --NavigationTermAST
	                        | NOT BaseArithmeticTermAST  --NavigationTermAST 

--    NavigationTermAST ::= BaseArithmeticTermAST 	
--                        | BaseArithmeticTermAST RIGHTARROW  TypeNameAST	
	
	BaseArithmeticTermAST ::= VariableRefAST 
	                        | ValueAST 	                     
	                        | LPAREN LogicalTermAST RPAREN
	                        | AsmFunctionLocationAST
	                        | GraphPatternCallAST
                            | PredefinedFunctionCallAST



                        

--	ArithmeticTermAST ::= MultArithmeticTermAST 
--	                    | ArithmeticTermAST PLUS MultArithmeticTermAST
--	                    | ArithmeticTermAST MINUS MultArithmeticTermAST
	
	-- Renamed from MultArithmeticTerm
--	MultArithmeticTermAST ::= BaseArithmeticTermAST
--	                        | MultArithmeticTermAST MULTIPLY BaseArithmeticTermAST
--	                        | MultArithmeticTermAST DIVIDE BaseArithmeticTermAST
--	                        | MultArithmeticTermAST REMAINDER BaseArithmeticTermAST

--	BaseArithmeticTermAST ::= VariableRefAST 
--	                        | ValueAST 	                     
--	                        | MINUS ValueAST 
---- Here the specification contains Term, but this should be ArithmeticTerm	                     
--	                        | LPAREN ArithmeticTermAST RPAREN
--	                        | AsmFunctionLocationAST
--                            | PredefinedFunctionCallAST

--------------------------------------------------------------------------------
-- Sec. 5.4.3 ASM Functions
--------------------------------------------------------------------------------

-- TODO: Check that IntegerLiteral is decimal
    AsmFunctionDefAST ::= OptAnnotationsAST asmfunction TypeNameAST ArityOrTypeDeclAST ReturnTypeOptAST InitialValuesOptAST
    
    ArityOrTypeDeclAST ::= DIVIDE ArityAST
                         | LPAREN TypeConstantsAST   
    
    ArityAST ::= DecimalIntegerLiteral

    InitialValuesOptAST ::= SEMICOLON
                          | LBRACE InitialValuesAST RBRACE

    InitialValuesAST ::= InitialValueAST 
                       | InitialValuesAST InitialValueAST 

-- Location is changed to ActualParameterDefAST 
    InitialValueAST ::= ActualParameterDefAST EQUAL ArithmeticTermAST SEMICOLON
    
--  LocationDefAST ::=  LPAREN LocationsOptAST RPAREN
--	LocationsOptAST ::= $empty | Location
--	Location ::= ArithmeticTermAST
--	           | Location COMMA ArithmeticTermAST

   TypeConstantsAST ::= QualifiedTypeNameAST RPAREN
                      | QualifiedTypeNameAST COMMA TypeConstantsAST 
   
--   QualifiedTypeConstantAST ::= 	QualifiedTypeNameAST ::= TypeNameAST
--	                       | QualifiedTypeNameAST DOT TypeNameAST                
   

-- Location is changed to ActualParameterDefAST 
-- TODO: Check that the QualifiedTypeNameAST is existing or it corresponds to a NativeFunction
	AsmFunctionLocationAST ::= ASMFunctionNameAST ActualParameterDefAST

--------------------------------------------------------------------------------
-- Sec. 5.4.4 Predefined Functions
--------------------------------------------------------------------------------

	PredefinedFunctionCallAST ::= BuiltInFunctionNameAST LPAREN ArithmeticTermAST RPAREN 
	                            | ConversionFunctionNameAST LPAREN ArithmeticTermAST RPAREN 
--	                         | QualifiedTypeNameAST ActualParameterDef
	
	BuiltInFunctionNameAST$BuiltInFunctionNameAST ::= ref | fqn | name | value | source | target 
	                         | multiplicity | aggregation | inverse

	ConversionFunctionNameAST$ConversionFunctionNameAST ::= toBoolean | toString 
	                         | toInteger | toDouble | toMultiplicity
                      
--------------------------------------------------------------------------------
-- Sec. 5.5 ASM Rules
--------------------------------------------------------------------------------
	AsmRuleDefAST ::= OptAnnotationsAST rule TypeNameAST DirectedFormalParameterDefAST EQUAL AsmRuleAST 
	
	AsmRulesAST ::= AsmRulesOptAST AsmRuleAST 
	
	AsmRulesOptAST ::= $empty
	              | AsmRulesOptAST AsmRuleAST 
	
	AsmRuleAST ::= RegularAsmRuleAST 
	             | IfRuleAST 
	             | TryRuleAST 
	             | ERROR_TOKEN
        /.$BeginAstAction
                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
          $EndAstAction
        ./	
	
	RegularAsmRuleAST ::= SimpleRuleAST 
	             | CompoundRuleAST 
	             | ModelManipulationRuleAST 

--	AsmRuleWithElse ::= RegularAsmRule
--	          | IfRuleWithElse
--	          | TryRuleWithElse

--------------------------------------------------------------------------------
-- Sec. 5.5.1 Simple Rules
--------------------------------------------------------------------------------
    SimpleRuleAST ::= SkipRuleAST | FailRuleAST 
                    | CallRuleAST | UpdateRuleAST 
                    | PrintRuleAST | LogRuleAST 
    
    SkipRuleAST ::= skip SEMICOLON
    
    FailRuleAST ::= fail SEMICOLON
    
    CallRuleAST ::= call QualifiedTypeNameAST ActualParameterDefAST SEMICOLON
    
    UpdateRuleAST ::= update VariableRefAST EQUAL ArithmeticTermAST SEMICOLON
                    | update AsmFunctionUpdateLocationAST EQUAL ArithmeticTermAST SEMICOLON
--                    | update NavigationLocationAST EQUAL ArithmeticTermAST SEMICOLON
--	NavigationLocationAST ::= BaseArithmeticTermAST RIGHTARROW  TypeNameAST	


	AsmFunctionUpdateLocationAST ::= ASMFunctionNameAST ActualParameterDefAST

	
    
    PrintRuleAST ::= print LPAREN LogicalTermAST RPAREN SEMICOLON
                 |   print LPAREN ArithmeticTermAST COMMA LogicalTermAST RPAREN SEMICOLON
                 | println LPAREN LogicalTermAST RPAREN SEMICOLON
                 | println LPAREN ArithmeticTermAST COMMA LogicalTermAST RPAREN SEMICOLON

    --OptBufferAST ::= $empty   
    --             | ArithmeticTermAST COMMA 
                 
    LogRuleAST ::= log LPAREN LogLevelAST COMMA ArithmeticTermAST RPAREN SEMICOLON
    
    LogLevelAST$LogLevelAST ::= debug | info | warning | error | fatal

                     
--------------------------------------------------------------------------------
-- Sec. 5.5.2 Compound Rules
--------------------------------------------------------------------------------

    CompoundRuleAST ::=  SequentialRuleAST | RandomRuleAST 
                | LetRuleAST | IterateRuleAST 
                | ChooseRuleAST | ForallRuleAST 
                | ParallelRuleAST | WhenRuleAST
                
	SequentialRuleAST ::= seq LBRACE AsmRulesAST RBRACE OptSemicolonAST  

	ParallelRuleAST ::= parallel LBRACE AsmRulesAST RBRACE OptSemicolonAST  
	
	RandomRuleAST ::= random LBRACE AsmRulesAST RBRACE OptSemicolonAST 

	OptSemicolonAST ::= $empty | SEMICOLON
	
	LetRuleAST ::= let VariableDefinitionsAST in AsmRuleAST 
	
	VariableDefinitionsAST ::= VariableDefinitionAST  
	                         | VariableDefinitionsAST COMMA VariableDefinitionAST 
	                      
	VariableDefinitionAST ::= VariableDefAST TypeOptAST EQUAL ArithmeticTermAST 
	
	IterateRuleAST ::= iterate AsmRuleAST 
	
	ChooseRuleAST ::= choose ConstrainedVariablesOptAST with ConditionAST DoActionOptAST  

	ForallRuleAST ::= forall ConstrainedVariablesOptAST with ConditionAST DoActionOptAST 
	
-- Logical terms are restricted to GraphPatternCalls and terms over AsmFunctionLoctions	
	ConditionAST ::= LogicalTermAST
--	ConditionAST ::= GraphPatternCallAST
	               | GTRuleCallAST 
--	               | TypedModelElementEnumAST
--	               | AsmFunctionLocationAST
--	               | ERROR_TOKEN


--  TypedModelElementEnumAST ::=
                  
  
	DoActionOptAST ::= SEMICOLON | do AsmRuleAST
	
	IfRuleAST ::= if LPAREN LogicalTermAST RPAREN AsmRuleAST 
	         | if LPAREN LogicalTermAST RPAREN AsmRuleAST else AsmRuleAST
--	         | if LPAREN LogicalTermAST RPAREN AsmRuleWithElse else AsmRule

--	IfRuleWithElse ::= if LPAREN LogicalTermAST RPAREN AsmRuleWithElse else AsmRuleWithElse

	TryRuleAST ::= try AsmRuleAST
	          | try AsmRuleAST else AsmRuleAST
--	          | try AsmRuleWithElse else AsmRule
--        TryOptElseAST ::= $empty | else AsmRuleAST

--	TryRuleWithElse ::= try AsmRuleWithElse else AsmRuleWithElse 
	          
	WhenRuleAST ::= when LPAREN WhenConditionAST RPAREN do AsmRuleAST
	
	-- Disjunction of elementary changes are considered
	WhenConditionAST ::= WhenChangeAST |  
	 	                   WhenConditionAST COMMA WhenChangeAST

	WhenChangeAST ::= new LPAREN VariableRefAST RPAREN 
	                | delete LPAREN VariableRefAST RPAREN
	                | changed LPAREN VariableRefAST RPAREN
	
--------------------------------------------------------------------------------
-- Sec. 5.5.3 Model Manipulation Rules
--------------------------------------------------------------------------------

	ModelManipulationRuleAST ::= CreateRuleAST | DeleteRuleAST | CopyRuleAST 
	                           | MoveRuleAST | ElementUpdateRuleAST 

	CreateRuleAST ::= new LPAREN CreateModelElementAST RPAREN SEMICOLON
	                | new LPAREN CreateRelationshipAST RPAREN SEMICOLON

--	CreateContentsAST ::= CreateModelElementAST | ManipulateRelationshipAST 
	
	CreateModelElementAST ::= QualifiedTypeNameAST CreateEntityBodyAST InConstraintOptAST 
	                     | QualifiedTypeNameAST CreateRelationBodyAST

	CreateEntityBodyAST ::= LPAREN VariableRefAST RPAREN 
	CreateRelationBodyAST ::= LPAREN VariableDefRefAST COMMA ArithmeticTermAST COMMA ArithmeticTermAST RPAREN 

	InConstraintOptAST ::= $empty | in ArithmeticTermAST

--	ManipulateRelationshipAST ::= ManipulateInheritanceAST | 
--	                              ManipulateInstantiationAST
	
    CreateRelationshipAST ::= supertypeOf TwoParametersAST
                            | subtypeOf TwoParametersAST
	                        | typeOf TwoParametersAST
	                        | instanceOf TwoParametersAST  
	
--	ManipulateRelationshipBodyAST ::= LPAREN ArithmeticTermAST COMMA ArithmeticTermAST RPAREN 
	
	DeleteRuleAST ::= delete LPAREN DeleteContentsAST RPAREN SEMICOLON
	                | delete LPAREN DeleteRelationshipAST RPAREN SEMICOLON
	
	DeleteContentsAST ::= ArithmeticTermAST DeleteSemanticsOptAST
	                    
	DeleteSemanticsOptAST ::= $empty | COMMA DeleteSemanticsAST
	
	DeleteSemanticsAST ::= delete_content | move_content	                    

    DeleteRelationshipAST ::= supertypeOf TwoParametersAST
                            | subtypeOf TwoParametersAST
	                        | typeOf TwoParametersAST
	                        | instanceOf TwoParametersAST  
	
	CopyRuleAST ::= copy LPAREN CopyContentsAST RPAREN SEMICOLON

	CopyContentsAST ::= ArithmeticTermAST COMMA ArithmeticTermAST 
						COMMA VariableRefAST COMMA CopySemanticsAST								

	CopySemanticsAST ::= copy_boundary_edges | skip_boundary_edges
									
	MoveRuleAST ::= move TwoParametersAST SEMICOLON

	TwoParametersAST ::= LPAREN ArithmeticTermAST COMMA ArithmeticTermAST RPAREN

	ElementUpdateRuleAST ::= ElementUpdateOpAST TwoParametersAST SEMICOLON
	
	ElementUpdateOpAST$ElementUpdateOpAST ::= rename | setValue | setFrom | setTo
	                     | setMultiplicity | setAggregation | setInverse
	
--------------------------------------------------------------------------------
-- Sec. 5.6 Naming 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Sec. 5.6.1 Base elements -> Part of the VTCLLexer
--------------------------------------------------------------------------------
	
--------------------------------------------------------------------------------
-- Sec. 5.6.2 Types and Names
--------------------------------------------------------------------------------

	
	QualifiedTypeNameAST ::= TypeNameAST
	                       | QualifiedTypeNameAST DOT TypeNameAST                
	
	TypeNameAST ::= NameLiteral 
	              | IDENTIFIER
	               --LocalNameAST
	              | UpperCaseLiteral
	              | KeywordAsIdentifier

	VariableRefAST ::= UpperCaseLiteral	

-- DummyVariables are currently disabled
	VariableDefRefAST ::= UpperCaseLiteral --| DummyVariableLiteral 	

	VariableDefAST ::= UpperCaseLiteral	

-- In ASM programs, all upper case literals and reserved words
-- should be quoted when used as a model element constant with local names 
	ValueQualifiedNameAST ::= ValueLocalNameAST 
	                        | QualifiedTypeNameAST DOT TypeNameAST
	ValueLocalNameAST ::= NameLiteral 
	                    | IDENTIFIER
	
	
	
	ASMFunctionNameAST ::= ValueQualifiedNameAST

--------------------------------------------------------------------------------
-- Sec. 5.6.3 Parameter and Variable Lists
--------------------------------------------------------------------------------

	FormalParameterDefAST ::= LPAREN FormalParamsAST RPAREN 
	                        | LPAREN RPAREN 
--	                        | ERROR_TOKEN
--        /.$BeginAstAction
--                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
--          $EndAstAction
--        ./	
	
               
	FormalParamsAST ::= PatternVariableDefAST TypeOptAST
	                  | FormalParamsAST COMMA PatternVariableDefAST TypeOptAST

	DirectedFormalParameterDefAST ::= LPAREN DirectedFormalParamsAST RPAREN 	
	                                | LPAREN RPAREN 
--	                                | ERROR_TOKEN
--        /.$BeginAstAction
--                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
--          $EndAstAction
--        ./	


	DirectedFormalParamsAST ::= DirectionKindAST VariableDefAST TypeOptAST
	               | DirectedFormalParamsAST COMMA DirectionKindAST VariableDefAST TypeOptAST

	DirectionKindAST ::= in | out | inout

    ActualParameterDefAST ::= LPAREN ActualParamsAST RPAREN
                            | LPAREN RPAREN
--	                        | ERROR_TOKEN
--        /.$BeginAstAction
--                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
--          $EndAstAction
--        ./	
		
-- Term is restricted to ArithmeticTerm in order to avoid conflicts
	ActualParamsAST ::= ArithmeticTermAST
	                  | ActualParamsAST COMMA ArithmeticTermAST

    ActualPatternParameterDefAST ::= LPAREN ActualParamsPatternVariablesAST RPAREN 
                                | LPAREN RPAREN
--	                            | ERROR_TOKEN
--        /.$BeginAstAction
--                    //reportErrorTokenMessage(getRhsTokenIndex(1), "Namespace import");
--          $EndAstAction
--        ./	


	ActualParamsPatternVariablesAST ::= PatternVariableRefAST 
                                   | ActualParamsPatternVariablesAST COMMA PatternVariableRefAST 
		        

	ConstrainedVariablesOptAST ::= $empty 
	                          | ConstrainedVariablesAST 

	ConstrainedVariablesAST ::= VariableDefAST TypeOptAST ContainmentConstraintOptAST 
	                       | ConstrainedVariablesAST COMMA VariableDefAST TypeOptAST ContainmentConstraintOptAST 

	ContainmentConstraintOptAST ::= $empty 
	                            | in ArithmeticTermAST
	                            | below ArithmeticTermAST

    TypeOptAST ::= $empty
                 | COLON QualifiedTypeNameAST

    ReturnTypeOptAST ::= $empty
                 | COLON QualifiedTypeNameAST
                 
--------------------------------------------------------------------------------
-- Sec. 5.6.4 Values and Constants
--------------------------------------------------------------------------------

	ValueAST ::= UndefValueAST 
	        | BooleanConstantAST 
	        | MultiplicityConstantAST 
	        | StringConstantAST 
	        | NumericConstantAST 
	        | ValueQualifiedNameAST
	
	UndefValueAST ::= undef
	
	BooleanConstantAST ::= false | true
	
	MultiplicityConstantAST ::= one_to_one | one_to_many 
	                       | many_to_one | many_to_many
	                       
	StringConstantAST ::= StringLiteral	                       
	        
	NumericConstantAST ::= DecimalIntegerLiteral        
                      | IntegerLiteral
                      | FloatingPointLiteral  
                      | DoubleLiteral         

	KeywordAsIdentifier$KeywordAsIdentifier ::= 
    namespace | import | machine | pattern | neg | find |
-- The following keywords conflict with entity definition, so they are disallowed without ''s 
--    check | supertypeOf | subtypeOf |  typeOf | instanceOf | 
    gtrule | precondition | postcondition | action | apply | xor |
    asmfunction | rule | skip | fail | call | update | print | println | log | debug | info | warning |
    error | fatal | seq | random | let | in | below | choose | forall | with | do | iterate | if | try | else |
    new | delete | delete_content | move_content | copy | copy_boundary_edges |
    skip_boundary_edges | move | rename | setValue | setFrom | setTo | setMultiplicity |
    setAggregation | setInverse | undef | true | false | one_to_one | one_to_many |
    many_to_one | many_to_many | ref | fqn | name | value | source | target | multiplicity | 
    aggregation | inverse | toBoolean | toString | toInteger | toDouble | toMultiplicity | out | inout |  
    parallel  | changed | when | shareable
    

--------------------------------------------------------------------------------
-- Annotations
--------------------------------------------------------------------------------

	OptAnnotationsAST ::= $empty | AnnotationsAST
	
	AnnotationsAST ::= AnnotationAST 
	                 | AnnotationsAST AnnotationAST

	AnnotationAST ::= AnnotationNameAST
	                | AnnotationNameAST LPAREN AnnotationBodyAST RPAREN
	
	AnnotationBodyAST ::= KeyValuePairAST
	                    | AnnotationBodyAST COMMA KeyValuePairAST
	                 
	KeyValuePairAST ::= TypeNameAST EQUAL TypeNameAST  
		        
	AnnotationNameAST ::= AnnotationLiteral
$End

--$Types
--    ForStatement ::= ForStatementNoShortIf
--$End
