/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;

public class ModelAndViewMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter returnType) {
        return ModelAndView.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue != null) {
            ModelAndView mav = (ModelAndView)returnValue;
            mavContainer.setViewName(mav.getViewName());
            if (!mav.isReference()) {
                mavContainer.setView((Object)mav.getView());
            }
            mavContainer.addAllAttributes(mav.getModel());
        } else {
            mavContainer.setRequestHandled(true);
        }
    }
}

