/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.internal.StandardAttribute;
import org.osgi.framework.Version;

public final class StandardArtifactDescriptor
implements ArtifactDescriptor {
    private static final Set<Attribute> EMPTY_ATTRIBUTE_SET;
    private final Map<String, Set<Attribute>> attributesIndex = new HashMap<String, Set<Attribute>>();
    private final Set<Attribute> attributes;
    private final URI uri;
    private final String type;
    private final String name;
    private final Version version;
    private final int hash;
    private final String filename;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.StandardArtifactDescriptor");
        EMPTY_ATTRIBUTE_SET = Collections.emptySet();
    }

    public StandardArtifactDescriptor(URI uri, String type, String name, Version version, String filename, Set<Attribute> attributes) {
        if (uri == null || type == null || name == null || version == null || attributes == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        for (Attribute attribute : attributes) {
            Set<Attribute> tempAttributes = this.attributesIndex.get(attribute.getKey());
            if (tempAttributes == null) {
                tempAttributes = new HashSet<Attribute>();
                this.attributesIndex.put(attribute.getKey(), tempAttributes);
            }
            tempAttributes.add(attribute);
        }
        this.attributes = attributes;
        this.filename = this.addAttributeIfNotAlreadyPresent("filename", filename);
        this.addAttributeIfNotAlreadyPresent("uri", uri.toString());
        this.uri = uri;
        this.addAttributeIfNotAlreadyPresent("type", type);
        this.type = type;
        this.addAttributeIfNotAlreadyPresent("name", name);
        this.name = name;
        this.addAttributeIfNotAlreadyPresent("version", version.toString());
        this.version = version;
        this.hash = this.type.hashCode() + this.name.hashCode() + this.version.hashCode();
    }

    private String addAttributeIfNotAlreadyPresent(String name, String value) {
        if (this.attributesIndex.containsKey(name)) {
            return this.attributesIndex.get(name).iterator().next().getValue();
        }
        if (value != null) {
            this.addAttribute(name, value);
        }
        return value;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Set<Attribute> getAttribute(String name) {
        Set<Attribute> tempAttributes = this.attributesIndex.get(name);
        if (tempAttributes == null) {
            tempAttributes = EMPTY_ATTRIBUTE_SET;
        }
        return tempAttributes;
    }

    @Override
    public Set<Attribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    private void addAttribute(String name, String value) {
        StandardAttribute requiredAttribute = new StandardAttribute(name, value);
        this.attributes.add(requiredAttribute);
        HashSet<StandardAttribute> requiredAttributeSet = new HashSet<StandardAttribute>();
        requiredAttributeSet.add(requiredAttribute);
        this.attributesIndex.put(name, requiredAttributeSet);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            StandardArtifactDescriptor sad = (StandardArtifactDescriptor)obj;
            return this.hash == sad.hash && this.type.equals(sad.type) && this.name.equals(sad.name) && this.version.equals((Object)sad.version);
        }
        return false;
    }

    public String toString() {
        return String.format("%s with %d attributes", this.uri.getPath(), this.attributes.size());
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

