/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpConnection;
import org.eclipse.equinox.http.HttpThreadPool;

public class HttpThread
extends Thread {
    private final Http http;
    private volatile boolean running;
    private final HttpThreadPool pool;
    private volatile HttpConnection conn;
    private final Object waitLock = new Object();

    public HttpThread(Http http, HttpThreadPool pool, String name) {
        super((ThreadGroup)pool, name);
        this.http = http;
        this.pool = pool;
        this.setDaemon(true);
    }

    public boolean isClosed() {
        return !this.running;
    }

    public void close() {
        this.running = false;
        if (this.conn == null) {
            this.interrupt();
        } else {
            try {
                this.conn.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void recall() {
        if (this.conn != null) {
            this.conn.setKeepAlive(false);
            if (!this.conn.isActive()) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(HttpConnection connParam) {
        if (this.running) {
            this.conn = connParam;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            if (this.conn == null) {
                Object object = this.waitLock;
                synchronized (object) {
                    this.pool.putThread(this);
                    try {
                        this.waitLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.running || this.conn == null) continue;
            this.conn.run();
            if (!this.conn.isClosed()) continue;
            this.conn = null;
        }
    }
}

