/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.impl;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.impl.LogController;
import org.eclipse.virgo.medic.impl.config.ConfigurationAdminConfigurationProvider;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.osgi.OSGiLogServiceListener;
import org.eclipse.virgo.medic.management.MedicMBeanExporter;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogService;
import org.slf4j.LoggerFactory;

public final class MedicActivator
implements BundleActivator {
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
    private volatile ServiceReference<ExtendedLogReaderService> logReaderReference;
    private LogController logController = null;
    private ConfigurationProvider configurationProvider = null;
    private MedicMBeanExporter medicMBeanExporter = null;

    public void start(BundleContext context) throws Exception {
        System.setProperty("logback.ignoreTCL", "true");
        this.configurationProvider = new ConfigurationAdminConfigurationProvider(context);
        this.registrationTracker.track(context.registerService(ConfigurationListener.class.getName(), (Object)this.configurationProvider, null));
        this.logController = new LogController(context, this.configurationProvider, this.registrationTracker);
        this.configurationProvider.addChangeListener(this.logController);
        this.logController.logStart();
        this.logController.eventLogStart();
        DumpGenerator dumpGenerator = this.logController.dumpStart();
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        context.registerService(MBeanServer.class, (Object)platformMBeanServer, null);
        this.medicMBeanExporter = new MedicMBeanExporter(this.configurationProvider, dumpGenerator);
        this.logReaderReference = context.getServiceReference(ExtendedLogReaderService.class);
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)context.getService(this.logReaderReference);
        logReader.addLogListener((LogListener)new OSGiLogServiceListener(LoggerFactory.getLogger(LogService.class)));
    }

    public void stop(BundleContext context) throws Exception {
        MedicMBeanExporter medicMBeanExporter2 = this.medicMBeanExporter;
        if (medicMBeanExporter2 != null) {
            medicMBeanExporter2.close();
        }
        this.registrationTracker.unregisterAll();
        ServiceReference<ExtendedLogReaderService> localLogReaderReference = this.logReaderReference;
        if (localLogReaderReference != null) {
            context.ungetService(localLogReaderReference);
        }
        LogController logController2 = this.logController;
        ConfigurationProvider configurationProvider2 = this.configurationProvider;
        if (configurationProvider2 != null) {
            configurationProvider2.removeChangeListener(logController2);
        }
        if (logController2 != null) {
            logController2.dumpStop();
            logController2.logStop();
        }
    }
}

