/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListener;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;

final class LoggingInstallArtifactLifecycleListener
implements InstallArtifactLifecycleListener {
    private final EventLogger eventLogger;

    public LoggingInstallArtifactLifecycleListener(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    @Override
    public void onInstallFailed(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.INSTALL_FAILED, installArtifact);
    }

    @Override
    public void onInstalled(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.INSTALLED, installArtifact);
    }

    @Override
    public void onInstalling(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.INSTALLING, installArtifact);
    }

    @Override
    public void onResolveFailed(InstallArtifact installArtifact) {
    }

    @Override
    public void onResolved(InstallArtifact installArtifact) {
    }

    @Override
    public void onResolving(InstallArtifact installArtifact) {
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable cause) {
        this.logEvent(DeployerLogEvents.START_FAILED, installArtifact, cause);
    }

    @Override
    public void onStartAborted(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.START_ABORTED, installArtifact);
    }

    @Override
    public void onStarted(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.STARTED, installArtifact);
    }

    @Override
    public void onStarting(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.STARTING, installArtifact);
    }

    @Override
    public void onStopFailed(InstallArtifact installArtifact, Throwable cause) {
        this.logEvent(DeployerLogEvents.STOP_FAILED, installArtifact, cause);
    }

    @Override
    public void onStopped(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.STOPPED, installArtifact);
    }

    @Override
    public void onStopping(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.STOPPING, installArtifact);
    }

    @Override
    public void onUnresolved(InstallArtifact installArtifact) {
    }

    @Override
    public void onUninstallFailed(InstallArtifact installArtifact, Throwable cause) {
        this.logEvent(DeployerLogEvents.UNINSTALL_FAILED, installArtifact, cause);
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.UNINSTALLED, installArtifact);
    }

    @Override
    public void onUninstalling(InstallArtifact installArtifact) {
        this.logEvent(DeployerLogEvents.UNINSTALLING, installArtifact);
    }

    private void logEvent(DeployerLogEvents event, InstallArtifact installArtifact) {
        this.eventLogger.log((LogEvent)event, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion()});
    }

    private void logEvent(DeployerLogEvents event, InstallArtifact installArtifact, Throwable cause) {
        if (cause == null) {
            this.logEvent(event, installArtifact);
        } else {
            this.eventLogger.log((LogEvent)event, cause, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion()});
        }
    }
}

