/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.standard;

import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.handler.BeanCreatingHandlerProvider;

public class AnnotatedEndpointConnectionManager
extends ConnectionManagerSupport
implements BeanFactoryAware {
    private final Object endpoint;
    private final BeanCreatingHandlerProvider<Object> endpointProvider;
    private WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("AnnotatedEndpointConnectionManager-");
    private volatile Session session;

    public AnnotatedEndpointConnectionManager(Object endpoint, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpointProvider = null;
        this.endpoint = endpoint;
    }

    public AnnotatedEndpointConnectionManager(Class<?> endpointClass, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpointProvider = new BeanCreatingHandlerProvider(endpointClass);
        this.endpoint = null;
    }

    public void setWebSocketContainer(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public WebSocketContainer getWebSocketContainer() {
        return this.webSocketContainer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.endpointProvider != null) {
            this.endpointProvider.setBeanFactory(beanFactory);
        }
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    protected void openConnection() {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AnnotatedEndpointConnectionManager.this.logger.isInfoEnabled()) {
                        AnnotatedEndpointConnectionManager.this.logger.info((Object)("Connecting to WebSocket at " + AnnotatedEndpointConnectionManager.this.getUri()));
                    }
                    Object endpointToUse = AnnotatedEndpointConnectionManager.this.endpoint != null ? AnnotatedEndpointConnectionManager.this.endpoint : AnnotatedEndpointConnectionManager.this.endpointProvider.getHandler();
                    AnnotatedEndpointConnectionManager.this.session = AnnotatedEndpointConnectionManager.this.webSocketContainer.connectToServer(endpointToUse, AnnotatedEndpointConnectionManager.this.getUri());
                    AnnotatedEndpointConnectionManager.this.logger.info((Object)"Successfully connected to WebSocket");
                }
                catch (Throwable ex) {
                    AnnotatedEndpointConnectionManager.this.logger.error((Object)"Failed to connect to WebSocket", ex);
                }
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        try {
            if (this.isConnected()) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
        }
    }

    @Override
    protected boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }
}

