/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.shell.internal.formatting.InstallArtifactCommandFormatter;

public abstract class AbstractInstallArtifactCommandFormatter<T extends ManageableArtifact>
implements InstallArtifactCommandFormatter<T> {
    protected static final int MAX_LINE_LENGTH = 80;
    private static final String NAME_COLUMN_NAME = "Name";
    private static final int NAME_COLUMN_MIN_WIDTH = "Name".length();
    private static final String VERSION_COLUMN_NAME = "Version";
    private static final int VERSION_COLUMN_MIN_WIDTH = "Version".length();
    private static final String STATE_COLUMN_NAME = "State";
    private static final int STATE_COLUMN_MIN_WIDTH = 11;

    @Override
    public List<String> formatList(List<T> artifacts) {
        Collections.sort(artifacts, new ManageableArtifactComparator());
        int maxNameLength = NAME_COLUMN_MIN_WIDTH;
        int maxVersionLength = VERSION_COLUMN_MIN_WIDTH;
        for (ManageableArtifact artifact : artifacts) {
            int nameLength = artifact.getName().length();
            maxNameLength = nameLength > maxNameLength ? nameLength : maxNameLength;
            int versionLength = artifact.getVersion().length();
            int n = maxVersionLength = versionLength > maxVersionLength ? versionLength : maxVersionLength;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int stateLength = 80 - (2 + maxNameLength + maxVersionLength);
        if (stateLength < 11) {
            stateLength = 11;
        }
        String singleLineFormat = String.format("%%-%ds %%-%ds %%%ds", maxNameLength, maxVersionLength, stateLength);
        lines.add(String.format(singleLineFormat, NAME_COLUMN_NAME, VERSION_COLUMN_NAME, STATE_COLUMN_NAME));
        for (ManageableArtifact artifact : artifacts) {
            lines.add(String.format(singleLineFormat, artifact.getName(), artifact.getVersion(), artifact.getState()));
        }
        return lines;
    }

    private static class ManageableArtifactComparator<T extends ManageableArtifact>
    implements Comparator<T> {
        private ManageableArtifactComparator() {
        }

        @Override
        public int compare(T artifact1, T artifact2) {
            int value = artifact1.getName().compareTo(artifact2.getName());
            if (value != 0) {
                return value;
            }
            return artifact1.getVersion().compareTo(artifact2.getVersion());
        }
    }
}

