/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.url;

import org.eclipse.virgo.snaps.core.internal.webapp.url.DefaultUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.ExactUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.ExtensionUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathUrlPattern;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UrlPatternFactory {
    private static final Logger logger = LoggerFactory.getLogger(UrlPatternFactory.class);

    UrlPatternFactory() {
    }

    public static UrlPattern create(String pattern) {
        if (PathUrlPattern.isPathPattern(pattern)) {
            logger.info("Pattern '{}' is a PathUrlPattern", (Object)pattern);
            return new PathUrlPattern(pattern);
        }
        if (ExtensionUrlPattern.isExtensionPattern(pattern)) {
            logger.info("Pattern '{}' is an ExtensionUrlPattern", (Object)pattern);
            return new ExtensionUrlPattern(pattern);
        }
        if (DefaultUrlPattern.isDefaultPattern(pattern)) {
            logger.info("Pattern '{}' is a DefaultUrlPattern", (Object)pattern);
            return new DefaultUrlPattern();
        }
        logger.info("Pattern '{}' is an ExactUrlPattern", (Object)pattern);
        return new ExactUrlPattern(pattern);
    }
}

