//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const FLOCK_MEDIA_CHANNEL_CID = Components.ID('{b208bef0-5658-11db-b0de-0800200c9a66}');
const FLOCK_MEDIA_CHANNEL_CONTRACTID = '@flock.com/media-channel;1';
const FLOCK_MEDIA_CHANNEL_IID = Components.interfaces.flockIMediaChannel;

function flockMediaChannel() {
}

flockMediaChannel.prototype= {
    title: "",

    QueryInterface: function(iid) {
        if (!iid.equals(Components.interfaces.nsISupports) &&
            !iid.equals(FLOCK_MEDIA_CHANNEL_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};


var flockMediaChannelModule = {
    registerSelf: function(compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(FLOCK_MEDIA_CHANNEL_CID, 
                                        "flockMediaChannel JS component", 
                                        FLOCK_MEDIA_CHANNEL_CONTRACTID, 
                                        fileSpec, 
                                        location,
                                        type);
    },

    getClassObject: function(compMgr, cid, iid) {
        if (!cid.equals(FLOCK_MEDIA_CHANNEL_CID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return flockMediaChannelFactory;
    },

    canUnload: function(compMgr) { return true; }
};

var flockMediaChannelFactory = {
    createInstance: function(outer, iid) {
        if (outer != null)
            throw Components.results.NS_ERROR_NO_AGGREGATION;
    
        if (!iid.equals(FLOCK_MEDIA_CHANNEL_IID) &&
            !iid.equals(Components.interfaces.nsISupports))
            throw Components.results.NS_ERROR_INVALID_ARG;

        return new flockMediaChannel();
    }
}

/* module initialisation */
function NSGetModule(comMgr, fileSpec) { return flockMediaChannelModule; }

