// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;
const CU = Components.utils;
const CR = Components.results;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");
CU.import("resource:///modules/FlockStringBundleHelpers.jsm");

const MMW_CONTRACTID = "@flock.com/migrate-myworld;1";
const MMW_CLASSID    = Components.ID("{c86e5445-b8fc-42e2-8fef-973a4f715b38}");
const MMW_CLASSNAME  = "Flock Myworld Migration";

const PREF_MYWORLD_WIDGETS_LAYOUT = "flock.myworld.widgets.layout";

/*************************************************************************
 * Component: flockMigrateMyWorld
 *************************************************************************/

function flockMigrateMyWorld() {
}

/*************************************************************************
 * flockMigrateMyWorld: XPCOM Component Creation
 *************************************************************************/

flockMigrateMyWorld.prototype = new FlockXPCOMUtils.genericComponent(
  MMW_CLASSNAME,
  MMW_CLASSID,
  MMW_CONTRACTID,
  flockMigrateMyWorld,
  CI.nsIClassInfo.SINGLETON,
  [
    CI.flockIMigratable
  ]
);

flockMigrateMyWorld.prototype._xpcom_categories = [
  { category: "flockMigratable" }
];

/*************************************************************************
 * flockMigrateMyWorld: private members
 *************************************************************************/

flockMigrateMyWorld.prototype._init =
function flockMigrateMyWorld__init() {
  this._logger = CC['@flock.com/logger;1'].createInstance(CI.flockILogger);
  this._logger.init("migrateMyWorld");
};

/*************************************************************************
 * flockMigrateMyWorld: flockIMigratable implementation
 *************************************************************************/

flockMigrateMyWorld.prototype.__defineGetter__("migrationName",
function flockMigrateMyWorld_getter_migrationName() {
  return flockGetString("common/migrationNames", "migration.name.myworld");
});

flockMigrateMyWorld.prototype.needsMigration =
function flockMigrateMyWorld_needsMigration(aOldVersion) {
  this._init();
  this._logger.debug("needsMigration('" + aOldVersion + "')");

  // Version: major.minor.revision
  var major = parseInt(aOldVersion[0], 10);
  var minor = parseInt(aOldVersion[2], 10);

  // Migrate myworld if the old version is 2.0 or earlier.
  if (major <= 1 || (major == 2 && minor == 0)) {
    return true;
  } else {
    return false;
  }
};

flockMigrateMyWorld.prototype.startMigration =
function flockMigrateMyWorld_startMigration(aOldVersion, aFlockMigrationProgressListener) {
  this._logger.debug(".startMigration('"
                     + aOldVersion
                     + "', 'aFlockMigrationProgressListener')");

  var ctxt = {
    listener: aFlockMigrationProgressListener
  };

  ctxt.listener.onUpdate(0, "Migrating My World");
  return {
    wrappedJSObject: ctxt
  };
};

flockMigrateMyWorld.prototype.finishMigration =
function flockMigrateMyWorld_finishMigration(ctxtWrapper) {
};

flockMigrateMyWorld.prototype.doMigrationWork =
function flockMigrateMyWorld_doMigrationWork(ctxtWrapper) {
  var nsJSON = CC["@mozilla.org/dom/json;1"].createInstance(CI.nsIJSON);
  var prefSvc = CC["@mozilla.org/preferences-service;1"]
                .getService(CI.nsIPrefBranch);

  var json;
  if (prefSvc.getPrefType(PREF_MYWORLD_WIDGETS_LAYOUT)) {
    json = prefSvc.getComplexValue(PREF_MYWORLD_WIDGETS_LAYOUT,
                                   CI.nsIPrefLocalizedString).data;

    var migratedLayoutObj = [];
    var layoutObj = nsJSON.decode(json);
    // Reverse the order of the old widget layout.
    for each (var column in layoutObj) {
      migratedLayoutObj.unshift(column);
    }
    
    // Add twitter search widget to far left in My World (far right of array).
    migratedLayoutObj.push({
      label: "twittersearch",
      url: "chrome://flock/content/start/twittersearch.xul",
      properties_url: "chrome://flock/locale/start/myworld.properties",
      multiple: "true",
      show: "true"
    });

    // Save migrated layout to pref store.
    var migratedLayout = nsJSON.encode(migratedLayoutObj);
    prefSvc.setCharPref(PREF_MYWORLD_WIDGETS_LAYOUT, migratedLayout);
  }

  return false;
};

/*************************************************************************
 * XPCOM Support - Module Construction
 *************************************************************************/

// Create array of components.
var componentsArray = [flockMigrateMyWorld];

// Generate a module for XPCOM to find.
var NSGetModule = FlockXPCOMUtils.generateNSGetModule(MMW_CLASSNAME,
                                                      componentsArray);
