//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;

Components.utils.import("resource:///modules/FlockXPCOMUtils.jsm");
FlockXPCOMUtils.debug = false;

const MODULE_NAME = "Flock People Refresh Listener";

// People Refresh Listener
const FLOCK_PEOPLEREFRESH_CLASS_NAME = "Flock People Refresh";
const FLOCK_PEOPLEREFRESH_CLASS_ID =
        Components.ID("{59a06798-fa38-42d9-9fae-065a035a3b00}");
const FLOCK_PEOPLEREFRESH_CONTRACT_ID = "@flock.com/people-refresh-listener;1";

// Interval to be used for people services when the sidebar is open
const SHORT_INTERVAL = 300; // seconds ==> 5 minutes

/**************************************************************************
 * BEGIN Flock People Refresh
 **************************************************************************/

// Constructor.
function PeopleRefresh() {
  this._coop = CC["@flock.com/singleton;1"]
               .getService(CI.flockISingleton)
               .getSingleton("chrome://flock/content/common/load-faves-coop.js")
               .wrappedJSObject;
  this._acUtils = CC["@flock.com/account-utils;1"]
                  .getService(CI.flockIAccountUtils);
  this._logger = CC["@flock.com/logger;1"].createInstance(CI.flockILogger);
  this._logger.init("peopleRefresh");
  this._successCount = 0;
  this._errorCount = 0;
  this._lastError = null;
};

/**************************************************************************
 * Flock People Refresh: XPCOM Component Creation
 **************************************************************************/

PeopleRefresh.prototype = new FlockXPCOMUtils.genericComponent(
  FLOCK_PEOPLEREFRESH_CLASS_NAME,
  FLOCK_PEOPLEREFRESH_CLASS_ID,
  FLOCK_PEOPLEREFRESH_CONTRACT_ID,
  PeopleRefresh,
  CI.nsIClassInfo.SINGLETON,
  [
    CI.flockIListener,
    CI.flockIPeopleRefreshListener
  ]
);

/**************************************************************************
 * Flock People Refresh: Private methods
 **************************************************************************/

PeopleRefresh.prototype._returnResultIfDone =
function PeopleRefresh__returnResultIfDone() {
  var answerCount = this._successCount + this._errorCount;
  if (answerCount >= this._processCount) {
    if (this._refreshUrn) {
      var refreshItem = this._coop.get(this._refreshUrn)
      if (refreshItem && this._acUtils.peopleSidebarOpen()) {
        var nextDate = Date.now() + this._shortRefreshDelay * 1000;
        refreshItem.nextRefresh = new Date(nextDate);
      }
    }
    if (this._errorCount == 0) {
      this._pollingListener.onResult();
    } else {
      this._pollingListener.onError(this._lastError);
    }
  }
};

/**************************************************************************
 * Flock People Refresh: flockIPeopleRefreshListener implementation
 **************************************************************************/

PeopleRefresh.prototype.init =
function PeopleRefresh_init(aProcessCount,
                            aRefreshUrn,
                            aPollingListener,
                            aShortRefreshDelay)
{
  this._processCount = aProcessCount;
  this._pollingListener = aPollingListener;
  this._refreshUrn = aRefreshUrn;
  this._shortRefreshDelay = aShortRefreshDelay;

  if (!this._shortRefreshDelay || this._shortRefreshDelay < SHORT_INTERVAL) {
    this._shortRefreshDelay = SHORT_INTERVAL;
  }
};

/**************************************************************************
 * Flock People Refresh: flockIListener implementation
 **************************************************************************/

PeopleRefresh.prototype.onSuccess =
function PeopleRefresh_onSuccess(aSubject, aTopic) {
  this._logger.debug("onSuccess(" + aSubject + ", '" + aTopic + "')");
  this._successCount++;
  this._returnResultIfDone();
};

PeopleRefresh.prototype.onError =
function PeopleRefresh_onError(aFlockError, aTopic) {
  var errString = "";
  this._errorCount++;
  if (aFlockError) {
    this._lastError = aFlockError;
    errString = "[" + aFlockError.errorCode + "]: " + aFlockError.errorString;
  }
  this._logger.error("onError(" + errString + ", '" + aTopic + "')");
  this._returnResultIfDone();
};

PeopleRefresh.prototype.refreshFinished =
function PeopleRefresh_refreshFinished() {
  this._processCount = this._successCount + this._errorCount;
  this._returnResultIfDone();
};

/**************************************************************************
 * END Flock People Refresh
 **************************************************************************/


/**************************************************************************
 * XPCOM Support - Module Construction
 **************************************************************************/

// Create array of components.
var gComponentsArray = [PeopleRefresh];

// Generate a module for XPCOM to find.
var NSGetModule = FlockXPCOMUtils.generateNSGetModule(MODULE_NAME,
                                                      gComponentsArray);

/**************************************************************************
 * END XPCOM Support
 **************************************************************************/
