// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const EBAY_LIVE_SEARCH_NAME = "eBay";
const EBAY_LIVE_SEARCH_CLASSID =
  Components.ID("{46a6a8b0-3327-11db-a98b-0800200c9a66}");

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockLiveSearchProvider.jsm");

function EBayLiveSearch() {
  this._init();
}

EBayLiveSearch.prototype = FlockLiveSearchProvider.generateComponent(
  EBAY_LIVE_SEARCH_NAME,
  EBAY_LIVE_SEARCH_CLASSID,
  EBayLiveSearch,
  "eBay"
);

EBayLiveSearch.prototype._getResults =
function ELS__getResults(aXHR, aMaxResults) {
  var items = aXHR.responseXML.getElementsByTagName("Item");

  var maxResults = Math.min(items.length, aMaxResults);

  var results = [];
  for (var i = 0; i < maxResults; i++) {
    var item = items[i];

    var title = item.getElementsByTagName("Title")[0].firstChild.nodeValue;
    var url = item.getElementsByTagName("ViewItemURLForNaturalSearch")[0]
                  .firstChild
                  .nodeValue;

    results.push({ title: title, url: url });
  }

  return results;
}

var NSGetModule =
  FlockLiveSearchProvider.generateNSGetModule(EBAY_LIVE_SEARCH_NAME,
                                              EBayLiveSearch);
