// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const TECHNORATI_LIVE_SEARCH_NAME = "Technorati";
const TECHNORATI_LIVE_SEARCH_CLASSID =
  Components.ID("{88a8b490-d044-4a3b-bb33-1798863ffabf}");

const TECHNORATI_SEARCH_API_URL = "http://api.technorati.com/search";
const TECHNORATI_API_KEY = "2dd47dbb72b25cc7130a450255af779b";


const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockLiveSearchProvider.jsm");


function TechnoratiLiveSearch() {
  this._init();
}

TechnoratiLiveSearch.prototype = FlockLiveSearchProvider.generateComponent(
  TECHNORATI_LIVE_SEARCH_NAME,
  TECHNORATI_LIVE_SEARCH_CLASSID,
  TechnoratiLiveSearch,
  null,
  "http://technorati.com/favicon.ico",
  "http://technorati.com/search/"
);

TechnoratiLiveSearch.prototype._getQueryURL =
function TLS__getQueryURL(aQuery, aNumResults) {
  return TECHNORATI_SEARCH_API_URL + "?"
          + "key=" + TECHNORATI_API_KEY
          + "&query=" + aQuery
          + "&format=xml"
          + "&start=1&limit=" + aNumResults;
}

TechnoratiLiveSearch.prototype._getResults =
function TLS__getResults(aXHR, aMaxResults) {
  var items = aXHR.responseXML.getElementsByTagName("weblog");

  var results = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];

    var title = item.getElementsByTagName("name")[0].firstChild.nodeValue;
    var url = item.getElementsByTagName("url")[0].firstChild.nodeValue;

    results.push({ title: title, url: url });
  }

  return results;
}

var NSGetModule =
  FlockLiveSearchProvider.generateNSGetModule(TECHNORATI_LIVE_SEARCH_NAME,
                                              TechnoratiLiveSearch);
