// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const YAHOO_LIVE_SEARCH_NAME = "Yahoo";
const YAHOO_LIVE_SEARCH_CLASSID =
  Components.ID("{88a8b490-d044-4a8b-bb03-1798864ffabf}");


const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockLiveSearchProvider.jsm");

function YahooLiveSearch() {
  this._init();
}

YahooLiveSearch.prototype = FlockLiveSearchProvider.generateComponent(
  YAHOO_LIVE_SEARCH_NAME,
  YAHOO_LIVE_SEARCH_CLASSID,
  YahooLiveSearch,
  "Yahoo!"
);

YahooLiveSearch.prototype._getResults =
function YLS__getResults(aXHR, aMaxResults) {
  var unescapeHTML = CC["@mozilla.org/feed-unescapehtml;1"]
                     .getService(CI.nsIScriptableUnescapeHTML);

  var items = aXHR.responseXML.getElementsByTagName("Result");

  var results = [];
  for (var i = 0; i < items.length; i++) {
    var item = items[i];

    var title = item.getElementsByTagName("Title")[0].firstChild.nodeValue;
    var url = item.getElementsByTagName("Url")[0].firstChild.nodeValue;

    results.push({ title: unescapeHTML.unescape(title), url: url });
  }

  return results;
}

var NSGetModule =
  FlockLiveSearchProvider.generateNSGetModule(YAHOO_LIVE_SEARCH_NAME,
                                              YahooLiveSearch);
