/*
 * BEGIN FLOCK GPL
 *
 * Copyright Flock Inc. 2005-2009
 * http://flock.com
 *
 * This file may be used under the terms of the
 * GNU General Public License Version 2 or later (the "GPL"),
 * http://www.gnu.org/licenses/gpl.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * END FLOCK GPL
 */

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockPrefsUtils.jsm");

var EXPORTED_SYMBOLS = ["FlockCastUtils"];

var FlockCastUtils = {};

FlockCastUtils.PREF_FLOCKCAST = "flock.flockcast.";
FlockCastUtils.PREF_FLOCKCAST_ACTIVE = "flock.flockcast.active";
FlockCastUtils.FB_CID = "@flock.com/people/facebook;1";
FlockCastUtils._metrics = CC["@flock.com/metrics-service;1"]
                          .getService(CI.flockIMetricsService);

FlockCastUtils.hasLoggedInFlockCastAccount =
function FCU_hasLoggedInFlockCastAccount(aStream, aAlgorithm) {
  var svc = CC[FlockCastUtils.FB_CID].getService(CI.flockIWebService);
  return svc.getAuthenticatedAccount() != null;
};

FlockCastUtils.setPublishAction =
function FCU_setPublishAction(aAccount, aAction, aValue) {
  var key = "publishStories" + aAction;
  aAccount.setCustomParam(key, aValue);

  var data = {
    "type": aAction,
    "sourceService": aAccount.getService().shortName,
    "targetService": "facebook",
    "value": aValue
  };
  this._metrics.report("FlockCast-BroadCast-Checkbox", data);
};


FlockCastUtils.__defineGetter__("_fbApi",
function FlockCastUtils_getter__fbApi() {
  if (!this._fbApiInst) {
    this._fbApiInst = CC["@flock.com/api/facebook;1"]
                      .getService(CI.flockIFacebookAPI);
  }
  return this._fbApiInst;
});

FlockCastUtils.getPublishAction =
function FCU_setPublishAction(aAccount, aAction) {
  var key = "publishStories" + aAction;
  return aAccount.getCustomParam(key, aAction);
};


FlockCastUtils.onCheck =
function FCU_onCheck(aEvent, aAccount, aAction) {
  var publish = aEvent.target.checked;
  FlockCastUtils.setPublishAction(aAccount, aAction, publish);
  if (publish === true) {
    FlockPrefsUtils.setBoolPref(FlockCastUtils.PREF_FLOCKCAST_ACTIVE, publish);
    FlockCastUtils._fbApi.addProfileBox(null);
  }
};

FlockCastUtils.onBlogCheck =
function FCU_onBlogCheck(aEvent, aCoopBlog) {
  var publish = aEvent.target.checked;
  aCoopBlog.publishStories = publish;

  var blogService = CC[aCoopBlog.getParent().serviceId]
                    .getService(CI.flockIBlogWebService);
  var data = {
    "type": "blog",
    "sourceService": blogService.shortName,
    "targetService": "facebook",
    "blogid": aCoopBlog.blogid,
    "value": publish
  };
  this._metrics.report("FlockCast-BroadCast-Checkbox", data);

  if (publish === true) {
    FlockPrefsUtils.setBoolPref(FlockCastUtils.PREF_FLOCKCAST_ACTIVE, publish);
    FlockCastUtils._fbApi.addProfileBox(null);
  }
};

FlockCastUtils.isActive =
function FCU_isActive() {
  return FlockPrefsUtils.getBoolPref(FlockCastUtils.PREF_FLOCKCAST_ACTIVE);
};

FlockCastUtils.enable =
function FCU_enable(aEnable) {
  FlockPrefsUtils.setBoolPref(FlockCastUtils.PREF_FLOCKCAST_ACTIVE, aEnable);

  this._metrics.report("FlockCast-Enable", aEnable);
};
