// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;

var EXPORTED_SYMBOLS = ["FlockFlickrStrings"];

/**
 * Some helpers to get around Flickr's spaceball and other stuff
 */

var FlockFlickrStrings = {};

var gWDLoaded = false;
var gFlickrStrings = {
  "imageUrlPattern": "https?:\/\/farm\d+\.static\.flickr\.com\/.*",
  "spaceballUrlPattern": "https?:\/\/l\.yimg\.com\/.*\/images\/spaceball\.gif"
};

FlockFlickrStrings._getWD =
function FlockFlickrStrings__getWD() {
  if (!this._wd) {
    this._wd = CC["@flock.com/web-detective;1"]
               .getService(CI.flockIWebDetective);
  }
  return this._wd;
}

FlockFlickrStrings._loadWDStrings =
function FlockFlickrStrings__loadWDStrings() {
  var wd = this._getWD();

  for (var s in gFlickrStrings) {
    gFlickrStrings[s] = wd.getString("flickr", s, gFlickrStrings[s]);
  }
  gWDLoaded = true;
}

FlockFlickrStrings.get =
function FlockFlickrStrings_get(aStringName) {
  if (!gWDLoaded) {
    this._loadWDStrings();
  }
  return gFlickrStrings[aStringName];
}

FlockFlickrStrings.getAsRegExp =
function FlockFlickrStrings_getAsRegExp(aStringName) {
  return new RegExp(this.get(aStringName));
}

FlockFlickrStrings.getImageUrlFromDoc =
function FlockFlickrStrings_getImageUrlFromDoc(aHTMLDocument) {
  var results = CC["@mozilla.org/hash-property-bag;1"]
                .createInstance(CI.nsIWritablePropertyBag2);
  this._getWD().detect("flickr", "spaceball", aHTMLDocument, results);
  return results.getPropertyAsAString("imageUrl");
}
