//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

var EXPORTED_SYMBOLS = ["QueryHelper"];

const CC = Components.classes;
const CI = Components.interfaces;
const CU = Components.utils;

CU.import("resource:///modules/FlockCryptoHash.jsm");

// JMC - Can't use | or : in a query, is this going to be sufficient?
// If there's a user: pair AND a search: pair, then it's a search within user
// If just a search: pair without a user: pair, it's a service-wide search
// If there's an album:, it restricts
// If there's a seq:, it specifies the starting point
function QueryHelper(aString) {
  if (aString) {
    var pairs = aString.split("|");
    for (var x in pairs) {
      var pair = pairs[x].split(":");
      if (pair[0] == 'search') {
        this[pair[0]] = decodeURIComponent(pair[1]);
      } else {
        this[pair[0]] = pair[1];
      }
    }
  }
  this._validKeys = ["user", "username", "search", "searchunique", "album",
                     "albumlabel", "preview", "favorites", "pool",
                     "special", "sort", "userdefined"];
  this._canonicalKeys = ["user", "username", "search", "searchunique", "album",
                         "albumlabel", "preview", "favorites", "pool",
                         "special", "sort", "userdefined"];
}

QueryHelper.prototype.__defineGetter__("stringVal", function () {
  var pairs = [];
  for (var x in this._validKeys) {
    if (this[this._validKeys[x]]) {
      if (this._validKeys[x] == "search") {
        pairs.push(this._validKeys[x]
                   + ":"
                   + encodeURIComponent(this[this._validKeys[x]]));
      } else {
        pairs.push(this._validKeys[x]
                   + ":"
                   + this[this._validKeys[x]]);
      }
    }
  }
  if (pairs.length) {
    return pairs.join("|");
  }
  return null;
});

QueryHelper.prototype.__defineGetter__("canonicalVal", function () {
  var pairs = [];
  for (var x in this._canonicalKeys) {
    if (this[this._canonicalKeys[x]]) {
      if (this._canonicalKeys[x] == "search") {
        pairs.push(this._canonicalKeys[x]
                   + ":"
                   + encodeURIComponent(this[this._canonicalKeys[x]]));
      } else {
        pairs.push(this._canonicalKeys[x]
                   + ":"
                   + this[this._canonicalKeys[x]]);
      }
    }
  }
  if (pairs.length) {
    return pairs.join("|");
  }
  return null;
});

QueryHelper.prototype.hasKey = function qh_hasKey(aKey) {
  return (this[aKey]);
};

QueryHelper.prototype.getKey = function qh_getKey(aKey) {
  return this[aKey];
};

QueryHelper.prototype.getEncodedKey = function qh_getEncodedKey(aKey) {
  return encodeURIComponent(this[aKey]);
};
