// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;

var EXPORTED_SYMBOLS = ["FlockTemplates"];

/**
 * A set of helper wrapping TrimPath's template.js (available in contrib)
 */

var loader = CC["@mozilla.org/moz/jssubscript-loader;1"]
             .getService(CI.mozIJSSubScriptLoader);
loader.loadSubScript("chrome://flock/content/contrib/template.js");

/* PRIVATE FUNCTIONS */

function getLocalUrl(url) {
  var req = CC["@mozilla.org/xmlextras/xmlhttprequest;1"]
            .createInstance(CI.nsIXMLHttpRequest);
  req.open('GET', url, false);
  req.overrideMimeType("text/plain");
  req.send(null);
  if (req.status == 0) {
    return req.responseText;
  } else {
    throw new Error("Failed to get " + url);
  }
}

/* PUBLIC FUNCTIONS */

var FlockTemplates = {
  parse: function FT_parse(aContent) {
    return TrimPath.parseTemplate(aContent);
  },

  parseFromChrome: function FT_parseFromChrome(aURL) {
    var content = getLocalUrl(aURL);
    return TrimPath.parseTemplate(content);
  }
};
