// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

Cc = Components.classes;
Ci = Components.interfaces;

var acUtils = Cc["@flock.com/account-utils;1"].getService(Ci.flockIAccountUtils);

var gAccount;
var gBlog;

function $(aId) {
  return document.getElementById(aId);
}

/*
 * Coop stuff
 */

var faves_coop = Components.classes["@flock.com/singleton;1"]
                           .getService(Components.interfaces.flockISingleton)
                           .getSingleton("chrome://flock/content/common/load-faves-coop.js")
                           .wrappedJSObject;

var gOrigBlog;
var blogService = Components.classes['@flock.com/flock-blog;1']
      .getService(Components.interfaces['flockIBlogService']);

function onLoad() {
  // Populate the drop-down
  var list = $("blog-api-popup");

  var webServices = blogService.services;
  while(webServices.hasMoreElements()) {
    var svc = webServices.getNext();
    svc.QueryInterface(Components.interfaces.flockICustomBlogWebService);
    svc.QueryInterface(Components.interfaces.nsIClassInfo);
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute('label', svc.name);
    menuitem.setAttribute('value', svc.contractID);
    list.appendChild(menuitem);
  }

  params = window.arguments[0];
  gOrigBlog = params.accountId;
  window.setTimeout("fillFields();",0);
}


function fillFields() {
  var urn = gOrigBlog;
  dump("Filling for "+gOrigBlog+"\n");

  gAccount = faves_coop.get(urn);

  $("blog-title").value = gAccount.name;
  $("blog-username").value = gAccount.accountId;
  try {
    $("blog-password").value = acUtils.getPassword(gOrigBlog).password;
  } catch (ex) {
    $("blog-password").value = "";
  }

  var blogList = $("blog-list");
  var blogListPopup = $("blog-list-popup");
  var myEnum = gAccount.children.enumerate();
  while (myEnum.hasMoreElements()) {
    var child = myEnum.getNext();
    if (child.isInstanceOf(faves_coop.Blog)) {
      var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
      item.setAttribute("id", child.id());
      item.setAttribute("label", child.name);
      item.setAttribute("oncommand", "updateBlog();");
      blogListPopup.appendChild(item);
    }
  }
  $("blog-list").selectedIndex = 0;
  updateBlog();
  
  updateDropdown(gAccount.serviceId);
}


function updateBlog() {
  gBlog = faves_coop.get($("blog-list").selectedItem.id);
  dump("Selected "+gBlog.id()+"\n");

  $("blog-blogid").value = gBlog.blogid;
  $("blog-uri").value = gBlog.apiLink;
}


function updateDropdown(apiname) {
  dump("Switching to "+apiname+"\n");
  $("blog-api-menu").value = apiname;
}

function validateAccount() {
  var name = $("blog-api-menu").value;
  var strbundle = document.getElementById("blogStringBundle");
  if(name=="unknown") {
    return strbundle.getString("flock.blog.account.select");
  }
  var t = $("blog-title").value;
  if(t == "") {
      return strbundle.getString("flock.blog.account.title");
  }
  return null;
}

function saveAccount() {
  var msg = validateAccount();

  if(msg) {
    alert(msg);
    return;
  }

  var t = $("blog-title").value;
  var u = $("blog-username").value;
  var p = $("blog-password").value;
  var b = $("blog-blogid").value;
  var uri = $("blog-uri").value;

  var apiName = $("blog-api-menu").selectedItem.value;

  gAccount.accountId = u;
  gAccount.serviceId = apiName;
  gBlog.blogid = b;
  gBlog.apiLink = uri;

  acUtils.setPassword(gOrigBlog, u, p);

  window.close();
}

