// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const EDITOR_URL = "chrome://flock/content/blog/editor.xul";

const SHELF_SRV = Components.classes['@mozilla.org/rdf/datasource;1?name=flock-shelf'].getService(Components.interfaces['flockIShelfService']);

Components.utils.import("resource:///modules/FlockPrefsUtils.jsm");

var flock_blog = {};

flock_blog.__defineGetter__("service", function () {
  if (flock_blog._service) return flock_blog._service;
  flock_blog._service = Components.classes['@flock.com/flock-blog;1'].getService(Components.interfaces.flockIBlogService);
  return flock_blog._service;
});


// Functions related to the default account 
function flock_blogSetDefaultAccountIndex(i) {
  FlockPrefsUtils.setIntPref("flock.blog.defaultAccountIndex", i);
}

function flock_blogGetDefaultAccountIndex(i) {
  try {
    return FlockPrefsUtils.getIntPref("flock.blog.defaultAccountIndex");
  }
  catch(e) {
    return 0;
  }
}

flock_blog.setDefaultAccount = function (acct) {
  FlockPrefsUtils.setCharPref("flock.blog.defaultAccount", acct);
}

flock_blog.__defineSetter__("defaultAccount", function (acct) {
  FlockPrefsUtils.setCharPref("flock.blog.defaultAccount", acct);
});

flock_blog.__defineGetter__("defaultAccount", function () {
  return FlockPrefsUtils.getCharPref("flock.blog.defaultAccount");
});


// New post, open post 
var flock_blogNewPost = function() {
  flock_blog.service.openEditor(null, null, null);
}

var flock_blogBlogThisCommand = {
  target: null,
  isEnabled: function() {
    return true;
  },
  onDrop: function(aSource) {
    this.target = aSource;
    this.exec();
  },
  exec: function() {
    // var topWindow = flock_mostRecentNavigator();
    var topWindow = top.window;
    var node = null;

    if(top.window.document.popupNode) {
      node = top.window.document.popupNode;
    }
    else {
      node = this.target;//this is set by a drop handler in the topbar - crazy
    }

    var contentDetector = new nsContentDetector();
    contentDetector.setTarget(node);

    var theCurrentBrowser = top.document
                               .getElementById("content")
                               .mCurrentBrowser;
    var selection = theCurrentBrowser.contentWindow.getSelection() + "";
    var data = "";
    var location = theCurrentBrowser.contentWindow.location + "";
    if(location.match(/^chrome:\/\/.+/)) {
      location = "";
    }
    var title = theCurrentBrowser.contentTitle + "";

    if(contentDetector.onImage) {
      data = '<blockquote cite="' + location + '">' + '<img src="' + contentDetector.imageURL + '" />' + "</blockquote>";
      if(title.length==0) title = location;
      data += '<cite cite="' + location + '"><a href="' + location + '">' + title + '</a>' + "</cite><br/><br/>";
    }
    else if(contentDetector.onLink) {
      var link = contentDetector.link;
      var location = link.href;
      var title = link.innerHTML;
      data = '<a href="' + location + '">' + title + "</a> <br/><br/>";
    }
    else if(selection.length == 0) {
      data = '<a href="' + location + '">' + title + "</a> <br/><br/>";
    }
    else {
      data = '<blockquote cite="' + location + '">' + selection + "</blockquote>";
      if(title.length==0) title = location;
      data += '<cite cite="' + location + '"><a href="' + location + '">' + title + '</a>' + "</cite><br/><br/>";
    }
    data = data.replace(/\n/g,"");
    data = data.replace(/\r/g,"");

    flock_blog.service.openEditor(title, data, "");
    return;
  }
}

var flock_blogCreateAccountCommand = {
    isEnabled: function() {
        return true;
    },
    exec: function() {
        flock_blogOpenWizard();
    }
}

function flock_openBlogPost(anId) {
  flock_blog.service.openPost(anId);
}


function flock_openOpenBlogDialog() {
  window.openDialog("chrome://flock/content/blog/blogOpenPost.xul",
                    "openDraftDialog", "chrome,modal,centerscreen", null);
}

function openBlogConfig() {
  var winMediator = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var blogOptions = winMediator.getMostRecentWindow('blogOptions');
  if (blogOptions) {
    blogOptions.focus();
  }
  else {
    window.openDialog("chrome://flock/content/blog/blogOptions.xul",
                      "blogOptions", "chrome,centerscreen,modal", null);
  }
}

function flock_blogOpenWizard(aDefaultToCustom) {
  var param = {
    defaultToCustom: aDefaultToCustom
  };
  window.openDialog("chrome://flock/content/blog/blogAccountWizard.xul",
                    "accountWizard", "chrome,modal,centerscreen", param);
}

function flock_goUpdateCommandSet(aSet)
{
  for(var i = 0;i < aSet.childNodes.length; ++i) {
    var command = aSet.childNodes.item(i);
    goUpdateCommand(command.id);
  }
}

function flock_blogSelectInSettings() {
  var sidebarObserver = Components.classes["@mozilla.org/observer-service;1"]
                                  .getService(Components.interfaces.nsIObserverService);

  sidebarObserver.notifyObservers(sidebarObserver,
                                  "toggleAccountsArea",
                                  "manualBlog");
}

function flock_blogLaunchSettings() {
  toggleSidebarWithMetric("flock_AccountsSidebarBroadcaster",
                          "AccountSidebar-Open",
                          null,
                          "BlogSetupAccount",
                          true);
  // We need to delay so that the accounts and services sidebar can open and load before we command it to do things.
  setTimeout('flock_blogSelectInSettings();', 500);
}
