// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const BLOG_SRV = Components.classes['@flock.com/flock-blog;1'].getService(Components.interfaces.flockIBlogService);

var faves_coop = Components.classes["@flock.com/singleton;1"]
                 .getService(Components.interfaces.flockISingleton)
                 .getSingleton("chrome://flock/content/common/load-faves-coop.js")
                 .wrappedJSObject;

function $(aId) {
  return document.getElementById(aId);
}

function onLoad() {
  var foldersPopup = $('foldersList');
  var accounts = faves_coop.get('http://flock.com/rdf#AccountsRoot');

  var importedEnum = BLOG_SRV.getDraftsFrom("imported");
  if (importedEnum.hasMoreElements()) {
    var strbundle = document.getElementById("blogStringBundle");

    var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
    item.setAttribute("class", "menuitem-iconic");
    item.setAttribute("id", "imported");
    item.setAttribute("label", strbundle.getString("flock.blog.open.imported"));
    item.setAttribute("oncommand", "selectFolder(this.id);");
    foldersPopup.appendChild(item);
  }

  var separator = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",
                                           "menuseparator");
  foldersPopup.appendChild(separator);

  var enum_ = accounts.children.enumerate();
  while (enum_.hasMoreElements()) {
    var account = enum_.getNext();
    var enum2 = account.children.enumerate();
    while (enum2.hasMoreElements()) {
      var child = enum2.getNext();
      if (child.isInstanceOf(faves_coop.Blog)) {
        var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
        item.setAttribute("class", "menuitem-iconic");
        item.setAttribute("id", child.id());
        item.setAttribute("label", child.title);
        item.setAttribute("src", account.favicon);
        item.setAttribute("oncommand", "selectFolder(this.id);");
        foldersPopup.appendChild(item);
      }
    }
  }

  var previewDoc = document.getElementById("preview-frame").contentWindow.document;
  var head = previewDoc.documentElement.getElementsByTagName("head")[0];
  var cssNode = previewDoc.createElement("link");
  cssNode.type = "text/css";
  cssNode.rel = "stylesheet";
  cssNode.href = "chrome://flock/content/blog/preview.css";
  cssNode.media = "screen";
  head.appendChild(cssNode);
  var scriptNode = previewDoc.createElement("script");
  scriptNode.type = "application/x-javascript";
  scriptNode.src = "chrome://flock/content/blog/preview.js";
  head.appendChild(scriptNode);

  selectFolder('unpublished');
}

function selectFolder(aId) {
  var draftList = document.getElementById('draftsTree');
  var id = (aId == 'unpublished')?'':aId;
  
  function makeDraftItem(aId, aTitle, aContent, aDate) {
    var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "richlistitem");

    item.setAttribute('id', aId + "");
    item.setAttribute('max-width', '200');
    item.setAttribute('context', 'draftSingleContext');
    item.setAttribute('onclick', "previewPost(this.getAttribute('postTitle'), this.getAttribute('postContent'));");
    item.setAttribute('postTitle', aTitle);
    item.setAttribute('postContent', aContent);
    item.setAttribute('ondblclick', "onAccept(); window.close()");
    item.setAttribute('name', aTitle);
    item.setAttribute('style', "padding: 10px; margin-right: 5px; border-bottom: 1px dotted black; overflow: hidden;");
    var box = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "vbox");
    var name = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "description");
    name.setAttribute('style', 'font-weight: bold');
    name.setAttribute('value', aTitle);
    var date = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "description");
    date.setAttribute('style', 'font-weight: italic');
    date.setAttribute('value', new Date(aDate));
    box.appendChild(name);
    box.appendChild(date);
    item.appendChild(box);

    return item;
  }
  
  var draftsEnum = BLOG_SRV.getDraftsFrom(id);
  while (draftList.firstChild)
    draftList.removeChild(draftList.firstChild);
  while (draftsEnum.hasMoreElements()) {
    var draft = draftsEnum.getNext().QueryInterface(Components.interfaces.flockIBlogDraft);
    var ditem = makeDraftItem(draft.id, draft.title, draft.content, draft.lastupdate);
    draftList.appendChild(ditem);
  }
  
  if (draftsEnum.firstChild)
    previewPost(draftsEnum.firstChild.getAttribute('postTitle'), draftsEnum.firstChild.getAttribute('postContent'));
}


function previewPost(aTitle, aContent) {
  var previewDoc = $("preview-frame").contentWindow.document;
  var body = previewDoc.documentElement.getElementsByTagName("body")[0];
  body.innerHTML = "<h1>"
                 + aTitle
                 + "</h1>"
                 + aContent.replace(/(\r)?\n/gi, "<br/>");
  body.setAttribute("onclick", "previewClick(event);");
  $('preview-deck').selectedIndex = 1;
}


function deleteSelected() {
  var item = $('draftsTree').selectedItem;

  if (!item)
    return;

  var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                    .getService(Components.interfaces.nsIPromptService);
  var strbundle = document.getElementById("blogStringBundle");
  var title = strbundle.getString("flock.blog.open.delete.title");
  var desc = strbundle.getString("flock.blog.open.delete.text");
  if (prompts.confirm(window, title, desc)) {
    BLOG_SRV.removeDraft(parseInt(item.id));
    selectFolder(document.getElementById('foldersMenulist').selectedItem.id);
  }
}


function onAccept() { 
  // window.arguments[0].result = document.getElementById('draftsTree').selectedItem.id;
  var theId = document.getElementById('draftsTree').selectedItem.id;
  BLOG_SRV.openPost(theId);
  return true;
}

