// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const BLOG_SRV = Components.classes['@flock.com/flock-blog;1'].getService(Components.interfaces.flockIBlogService);

Cc = Components.classes;
Ci = Components.interfaces;

/*
 * Coop stuff
 */

var faves_coop = Components.classes["@flock.com/singleton;1"]
                           .getService(Components.interfaces.flockISingleton)
                           .getSingleton("chrome://flock/content/common/load-faves-coop.js")
                           .wrappedJSObject;

function $(aId) {
  return document.getElementById(aId);
}

function onLoad() {
  populatesBlogList();
}


function populatesBlogList() {
  var defaultBlog = BLOG_SRV.getDefaultBlog();
  var blogList = $("accountList");
  var accounts = faves_coop.get('http://flock.com/rdf#AccountsRoot');
  var enum_ = accounts.children.enumerate();
  while (blogList.getRowCount() > 0)
    blogList.removeItemAt(0);
  while (enum_.hasMoreElements()) {
    var account = enum_.getNext();
    var enum2 = account.children.enumerate();
    while (enum2.hasMoreElements()) {
      var child = enum2.getNext();
      if (child.isInstanceOf(faves_coop.Blog)) {
        var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "listitem");
        item.setAttribute("class", "listitem-iconic");
        item.setAttribute("id", child.id());
        item.setAttribute("label", child.title);
        item.setAttribute("image", account.favicon);
        item.setAttribute("serviceId", account.serviceId);
        item.setAttribute("accountId", account.id());
        if (defaultBlog == "") {
          defaultBlog = child.id();
          BLOG_SRV.setDefaultBlog(defaultBlog);
        }
        if (defaultBlog == child.id()) {
          item.setAttribute("class", "listitem-iconic selected-blog");
        }
        blogList.appendChild(item);
      }
    }
  }
  updateButtons();
}


function updateButtons() {
  var noselection = (!$('accountList').selectedItem);

  var isCustomBlog = false;
  if (!noselection) {
    var serviceId = $("accountList").selectedItem.getAttribute('serviceId');
    var accountId = $("accountList").selectedItem.getAttribute('accountId');
    var svc = Cc[serviceId].getService(Ci.flockIWebService);

    try {
      svc.QueryInterface(Ci.flockICustomBlogWebService);
      isCustomBlog = true;
    }
    catch(e) {
      isCustomBlog = false
    }
  }

  $('remove-button').setAttribute('disabled', noselection);
  $('default-button').setAttribute('disabled', noselection);
  $('edit-button').setAttribute('disabled', noselection || (!isCustomBlog));
}


function addBlog() {
  flock_blogOpenWizard();
  populatesBlogList();
}


function removeBlog() {
  var prompts = Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService);
  var strbundle = document.getElementById("blogStringBundle");
  var title = strbundle.getString("flock.blog.options.forget.title");
  var desc = strbundle.getString("flock.blog.options.forget.desc");
  if (!prompts.confirm(window, title, desc))
    return;

  var serviceId = $("accountList").selectedItem.getAttribute('serviceId');
  var accountId = $("accountList").selectedItem.getAttribute('accountId');
  var svc = Cc[serviceId].getService(Ci.flockIWebService);

  svc.removeAccount(accountId);
  populatesBlogList();
}


function editBlog() {
  var serviceId = $("accountList").selectedItem.getAttribute('serviceId');
  var accountId = $("accountList").selectedItem.getAttribute('accountId');
  var svc = Cc[serviceId].getService(Ci.flockIWebService);

  var isCustomBlog;
  try {
    svc.QueryInterface(Ci.flockICustomBlogWebService);
    isCustomBlog = true;
  }
  catch(e) {
    isCustomBlog = false
  }

  if (isCustomBlog) {
    var param = {
      accountId: accountId
    }
    window.openDialog("chrome://flock/content/blog/blogAccountDlg.xul",
                      "editCustomBlog", "modal,centerscreen", param);
  }
  populatesBlogList();
}


function makeDefault() {
  var blogId = $("accountList").selectedItem.id;
  BLOG_SRV.setDefaultBlog(blogId);
  populatesBlogList();
}
