// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const BLOG_SRV = Components.classes['@flock.com/flock-blog;1'].getService(Components.interfaces.flockIBlogService);

function makeDraftItem(aTitle, aContent, aDate) {
  var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "richlistitem");

  item.setAttribute('max-width', '200');
  item.setAttribute('name', aTitle);
  item.setAttribute('style', "padding: 10px; margin-right: 5px; border-bottom: 1px dotted black; overflow: hidden;");
  var box = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "vbox");
  var name = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "description");
  name.setAttribute('style', 'font-weight: bold');
  name.setAttribute('value', aTitle);
  var date = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "description");
  date.setAttribute('style', 'font-weight: italic');
  date.setAttribute('value', new Date(aDate));
  box.appendChild(name);
  box.appendChild(date);
  item.appendChild(box);

  return item;
}


function load() {
  var draftsTree = document.getElementById('draftsTree');

  var enum_ = BLOG_SRV.getAllRecovery();
  while (enum_.hasMoreElements()) {
    var recovery = enum_.getNext().QueryInterface(Components.interfaces.flockIBlogDraft);
    var item = makeDraftItem(recovery.title, recovery.content, recovery.lastupdate);
    draftsTree.appendChild(item);
  }
}

function looseChanges() {
  var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
  var strbundle = document.getElementById("blogStringBundle");
  var title = strbundle.getString("flock.blog.options.recover.title");
  var desc = strbundle.getString("flock.blog.options.recover.desc");
  if (prompts.confirm(window, title, desc)) {
    BLOG_SRV.looseRecovery();
    return true;
  }
  else
    return false;
}

function recover() {
  var posts = new Array();

  var enum_ = BLOG_SRV.getAllRecovery();
  while (enum_.hasMoreElements()) {
    var item = enum_.getNext().QueryInterface(Components.interfaces.flockIBlogDraft);
    posts.push({
      name: item.title,
      content: item.content,
      tags: item.tags
    });
  }

  BLOG_SRV.looseRecovery();

  // We need to loop again to open the blog editor with a clean recovery list
  // in coop -- otherwise, the recovery dialog appears again
  for (i=0; i<posts.length; i++)
    BLOG_SRV.openEditor(posts[i].name, posts[i].content, posts[i].tags);
  return true; 
}
