// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

function previewClick (event) {
  var linkUrl;
  var truveo = null;
  var isLink = false;
  try {
    //The parentNode is just incase we have an image or other object wrapped around a mailto link.
    linkUrl = event.originalTarget.parentNode.getAttribute('href').toString();
    truveo = event.originalTarget.parentNode.getAttribute("truveo");
    isLink = true;
  } catch (e) {
    linkUrl = null;
  }
  try {
    linkUrl = event.originalTarget.getAttribute('href').toString();
    truveo = event.originalTarget.getAttribute("truveo");
    isLink = true;
  } catch (e) { }
  if (isLink && linkUrl) {
    event.preventDefault();
    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
    recent = wm.getMostRecentWindow("navigator:browser");

    var linkprefs = Components.classes["@mozilla.org/preferences-service;1"]
              .getService(Components.interfaces.nsIPrefService)
              .getBranch("browser.link.");
    var newWindow = linkprefs.getIntPref ("open_newwindow");

    // Always open truveo in a new window as it resizes the browser.
    if (newWindow == 2 || truveo != null)
      recent.open(linkUrl);
    else {
      var browser = recent.document.getElementById('content');
      browser.loadOneTab(linkUrl, null, null, null, false);
    }
  }
}
