//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//


var indexerOverlay = {

  init: function() {
    var indexer = Cc["@flock.com/indexer;1"].getService(Ci.flockIIndexer);
    getBrowser().addEventListener("load", indexer, true);
  },

  uninit: function() {
    var indexer = Cc["@flock.com/indexer;1"].getService(Ci.flockIIndexer);
    getBrowser().removeEventListener("load", indexer, true);
  },

  handleEvent: function(aEvent) {
    switch(aEvent.type) {
      case "load":
        this.init();
        break;
      case "unload":
        this.uninit();
        break;
    }
  }

};


window.addEventListener("load", indexerOverlay, false);
window.addEventListener("unload", indexerOverlay, false);

