// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

// the default object definitions for the Favorites datastore
// passed into this environment are Coop (the type) and coop (the instance)

const FLOCK_NS = "http://flock.com/rdf#";
const NSCP_NS = "http://home.netscape.com/NC-rdf#";
const RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
const WEB_NS = "http://home.netscape.com/WEB-rdf#";
const FOAF_NS = "http://xmlns.com/foaf/0.1/";

coop.Identity = coop.add_type (FLOCK_NS + "Identity", {
  inherits_from: FLOCK_NS + "WebObject",
  fields: {
    serviceId: FLOCK_NS + "serviceId",
    accountId: FLOCK_NS + "accountId",
    avatar: FLOCK_NS + "avatar",
    status: FLOCK_NS + "status",
    statusMessage: FLOCK_NS + "statusMessage",
    statusMessageUrl: FLOCK_NS + "statusMessageUrl",
    lastUpdate: FLOCK_NS + "lastUpdate",
    lastUpdateType: FLOCK_NS + "lastUpdateType",
    unseenMedia: FLOCK_NS + "unseenMedia",
    totalMedia: FLOCK_NS + "totalMedia",
    lastUploadedMedia: FLOCK_NS + "lastUploadedMedia",
    lastSeenUploadedMedia: FLOCK_NS + "lastSeenUploadedMedia",
    screenName: FLOCK_NS + "screenName"
  },
  field_types: {
    lastUpdate: Coop.integer,
    unseenMedia: Coop.stringinteger,
    totalMedia: Coop.stringinteger
  },
  field_defaults: {
    flockType: "identity",
    rdftype: FLOCK_NS + "Identity",
    lastProfileUpdate: 0,
    unseenMedia: 0,
    totalMedia: 0,
    isIndexable: true,
    lastUploadedMedia: ""
  }
});

coop.Identity.prototype.getAccount = function Identity_getAccount() {
 var parents = this.getParents();
 for each (var parent in parents) {
   if (parent.flockType == "FriendsList") {
     return parent.account;
   }
 }
 return null;
};

coop.Account.prototype.addPerson =
function Account_addPerson(aPerson, aLastUpdate) {
  var identityUrn = "urn:flock:identity:"
                    + this.service.name.toLowerCase() + ":"
                    + this.accountId + ":" + aPerson.accountId;
  var identity = new coop.Identity(identityUrn, aPerson);
  if (!this.friendsList.children.has(identity)) {
    identity.serviceId = this.service.serviceId;
    this.friendsList.children.add(identity);
  }
  if (aLastUpdate != null) {
    identity.lastUpdate = aLastUpdate; // triggers the RDF observers
  }
  return identity;
}

coop.FriendsList = coop.add_type (FLOCK_NS + "FriendsList", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    account: FLOCK_NS + "account"
  },
  field_types: {
    account: Coop.object
  },
   field_defaults: {
    flockType: "FriendsList",
    rdftype: FLOCK_NS + "FriendsList"
  },
  container: "Seq"
});

coop.FriendActivityLog = coop.add_type(FLOCK_NS + "FriendActivityLog", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    account: FLOCK_NS + "account"
  },
  field_types: {
    account: Coop.object
  },
  field_defaults: {
    flockType: "FriendActivityLog",
    rdftype: FLOCK_NS + "FriendActivityLog"
  },
  container: "Seq"
});

coop.Activity = coop.add_type(FLOCK_NS + "Activity", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    updateType: FLOCK_NS + "updateType",
    updateDate: FLOCK_NS + "updateDate",
    updateValue: FLOCK_NS + "updateValue",
    updateURL: FLOCK_NS + "updateURL"
  },
  field_types: {
    updateDate: Coop.date
  },
  field_defaults: {
    flockType: "Activity",
    rdftype: FLOCK_NS + "Activity",
    updateValue: new Date(0)
  }
});

coop.FriendActivity = coop.add_type(FLOCK_NS + "FriendActivity", {
  inherits_from: FLOCK_NS + "Activity",
  fields: {
    identity: FLOCK_NS + "Identity"
  },
  field_types: {
    identity: Coop.object
  },
  field_defaults: {
    flockType: "FriendActivity",
    rdftype: FLOCK_NS + "FriendActivity"
  }
});

coop.NonFriendActivity = coop.add_type(FLOCK_NS + "NonFriendActivity", {
  inherits_from: FLOCK_NS + "Activity",
  fields: {
    avatar: FLOCK_NS + "avatar",
    screenName: FLOCK_NS + "screenName"
  },
  field_types: {
  },
  field_defaults: {
    flockType: "NonFriendActivity",
    rdftype: FLOCK_NS + "NonFriendActivity"
  }
});

coop.Person = coop.add_type(FLOCK_NS+"Person", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    nameIdentity: FLOCK_NS + "nameIdentity",
    avatarIdentity: FLOCK_NS + "avatarIdentity",
    statusMessageIdentity: FLOCK_NS + "statusMessageIdentity",
    unseenMedia: FLOCK_NS + "unseenMedia"
  },
  field_types: {
    nameIdentity: Coop.object,
    avatarIdentity: Coop.object,
    statusMessageIdentity: Coop.object,
    unseenMedia: Coop.stringinteger
  },
  field_defaults: {
    rdftype: FLOCK_NS + "Person",
    flockType: "person",
    unseenMedia: 0
  },
  container: "Seq"
});

coop.NewsFeedEvent = coop.add_type(FLOCK_NS+"NewsFeedEvent", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    description: FLOCK_NS + "description",
    icon: FLOCK_NS + "icon",
    images: FLOCK_NS + "images"
  },
  field_multiple: {
    images: true
  }
});
