//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

Components.utils.import("resource:///modules/FlockPrefsUtils.jsm");

var FlockTabs = {};

// Pref Values:
//  1 => leave it as requested
//  2 => new window
//  3 => new tab
FlockTabs.getInternalOpenLocation =
function FlockTabs_getInternalOpenLocation() {
  return FlockPrefsUtils.getIntPref("flock.browser.link.openInternal");
};

// Pref Values:
//  1 => leave it as requested
//  2 => new window
//  3 => new tab
FlockTabs.getWebpageOpenLocation =
function FlockTabs_getWebpageOpenLocation() {
  return FlockPrefsUtils.getIntPref("flock.browser.link.openWebpage");
};

FlockTabs.openURL =
function FlockTabs_openURL(aUrl, aEvent, aType) {
  if (aType === undefined) {
    aType = "internal";
  }
  var openIn = "current";
  // First check to make sure that some behaviour is not explicity being forced
  if (aEvent && (aEvent.button == 1 ||
                 aEvent.metaKey || aEvent.ctrlKey))
  {
    // Middle click, or Ctrl/Meta Key held down
    openIn = "tab";
  } else if (aEvent && aEvent.shiftKey) {
    // Shift key held down
    openIn = "window";
  } else {
    var openType = FlockPrefsUtils.getIntPref("flock.browser.link.openWebpage");
    if (aType == "internal") {
      openType = FlockPrefsUtils.getIntPref("flock.browser.link.openInternal");
    }
    switch (openType) {
      case 2: // Force new window
        openIn = "window";
        break;
      case 3: // New tab
        openIn = "tab";
        break;
      default: // Default
        if (openIn == "current" && gBrowser.currentURI.spec == "about:myworld") {
          // Don't load over MyWorld.  Load in a new tab.
          openIn = "tab";
        }
    }
  }
  openUILinkIn(aUrl, openIn);
};
