//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

var tooltipHider = {
  mLastTarget: null,
  mActionList: {menu: true, menuitem: true},

  onmouseover: function(aEvent) {
    if(aEvent.target.getAttribute("tooltip") ||
       aEvent.target.getAttribute("tooltiptext") ||
       aEvent.target.getAttribute("donthide")) {
      tooltipHider.mLastTarget = null;
    } else {
      tooltipHider.mLastTarget = aEvent.target;
    }
  },

  onpopupshowing: function(aEvent) {
    if(tooltipHider.mLastTarget &&
       tooltipHider.mActionList[tooltipHider.mLastTarget.nodeName] &&
       aEvent.originalTarget.nodeName == "tooltip") {
      aEvent.preventDefault();
    }
  }
};

window.addEventListener("mouseover", tooltipHider.onmouseover, false);
window.addEventListener("popupshowing", tooltipHider.onpopupshowing, false);
