// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

Components.utils.import("resource:///modules/FlockOnlineFavsUtils.jsm");

var faves_coop = Components.classes['@flock.com/singleton;1']
                           .getService(Components.interfaces.flockISingleton)
                           .getSingleton("chrome://flock/content/common/load-faves-coop.js")
                           .wrappedJSObject;

var FlockDiscovery = {};

FlockDiscovery.turnOffMessage =
function FlockDiscovery_turnOffMessage(aValue) {
  var nBox = gBrowser.getNotificationBox();
  nBox.dontShowMessage(aValue);
}

var FlockFavoritesMenu = {};

FlockFavoritesMenu.FAV_CHANNELS_ROOT = "urn:media:favorites";
FlockFavoritesMenu.XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

FlockFavoritesMenu.onload = function FlockFavoritesMenu_onload() {
  var onlineFolderId = onlineFavoritesBackend.getOnlineRootId();
  var onlinePlace = PlacesUtils.getQueryStringForFolder(onlineFolderId);
  document.getElementById("flockOnlineFolderPopup").place = onlinePlace;
}

FlockFavoritesMenu.showEmptyItem =
function FlockFavoritesMenu_showEmptyItem(aPopup) {
  if (aPopup.childNodes.length <= 0) {
    var empty = document.createElement("menuitem");
    var label = PlacesUIUtils.getString("bookmarksMenuEmptyFolder");
    empty.setAttribute("label", label);
    empty.setAttribute("disabled", true);
    empty.setAttribute("flockEmpty", true);
    aPopup.appendChild(empty);
  } else {
    var children = aPopup.childNodes;
    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      if (child.getAttribute("flockEmpty")) {
        aPopup.removeChild(child);
      }
    }
  }
}

FlockFavoritesMenu.onMediaPopupShowing =
function FlockFavoritesMenu_onMediaPopupShowing(aEvent) {
  FlockMedia.addMediaStreams(document.getElementById("mediabar-favorites-popup"),
                             this.FAV_CHANNELS_ROOT,
                             null);
}

FlockFavoritesMenu.populateFeedFolder =
function FlockFavoritesMenu_populateFeedFolder(aMenuPopup, aFeedFolder) {
  var feedManager = Components.classes["@flock.com/feed-manager;1"]
                    .getService(Components.interfaces.flockIFeedManager);

  while (aMenuPopup.lastChild) {
    aMenuPopup.removeChild(aMenuPopup.lastChild);
  }

  var children = aFeedFolder.getChildren();
  while (children.hasMoreElements()) {
    var folderItem = children.getNext();
    if (folderItem instanceof Components.interfaces.flockIFeedFolder) {
      var menu = document.createElementNS(this.XUL_NS, "menu");
      menu.setAttribute("label", folderItem.getTitle());
      menu.setAttribute("class", "menu-iconic bookmark-item");
      menu.setAttribute("container", "true");
      var menupopup = document.createElementNS(this.XUL_NS, "menupopup");
      menupopup.feedFolder = folderItem;
      menupopup.setAttribute("onpopupshowing",
                             "FlockFavoritesMenu.populateFeedFolder(this, this.feedFolder);"
                             + "event.stopPropagation()");
      menu.appendChild(menupopup);
      aMenuPopup.appendChild(menu);
    }
    else if (folderItem instanceof Components.interfaces.flockIFeed) {
      var menuitem = document.createElementNS(this.XUL_NS, "menuitem");
      menuitem.setAttribute("label", folderItem.getTitle());
      menuitem.setAttribute("class", "menuitem-iconic bookmark-item");
      if (folderItem.getFavicon()) {
        menuitem.setAttribute("image", folderItem.getFavicon().spec);
      }
      menuitem.setAttribute("url", folderItem.getURL().spec);
      menuitem.setAttribute("oncommand", "FlockFeeds.openSidebar('FeedsMenuItemClick'); "
                            + "openUILink('flock://favorites/urn:flock:feed:' +"
                            + " this.getAttribute('url')); "
                            + "event.stopPropagation();");
      aMenuPopup.appendChild(menuitem);
    }
  }
  FlockFavoritesMenu.showEmptyItem(aMenuPopup);
}

FlockFavoritesMenu.onFeedsPopupShowing =
function FlockFavoritesMenu_onFeedsPopupShowing(aEvent) {
  var feedManager = Components.classes["@flock.com/feed-manager;1"]
                    .getService(Components.interfaces.flockIFeedManager);

  var news = feedManager.getFeedContext("news");
  var menupopup = document.getElementById("flock-feeds-popup");
  FlockFavoritesMenu.populateFeedFolder(menupopup, news.getRoot());
}


window.addEventListener("load", FlockFavoritesMenu.onload, false);
