//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//
//
const CC = Components.classes;
const CI = Components.interfaces;
const CU = Components.utils;

const OOBE_CHROME_LOCATION = "chrome://flock/content/oobe/flock_oobe.swf";
const PREF_FLOCK_FIRSTRUN_UUID = "flock.firstrun.uuid";
const PREF_FLOCK_METRICS_ENABLED = "flock.metrics.enabled";
const METRICS_TRACKING_SERVER = "http://stats.flock.com/anonusagestats/";

CU.import("resource:///modules/FlockPrefsUtils.jsm");

var gMetricsSvc = CC["@flock.com/metrics-service;1"]
                  .getService(CI.flockIMetricsService);
var gHiddenWindow = CC["@mozilla.org/appshell/appShellService;1"]
                    .getService(CI.nsIAppShellService)
                    .hiddenDOMWindow;

function onLoad() {
  // What chapter should we play?
  var chapterToPlay = null;
  if (window.arguments) {
    chapterToPlay = window.arguments[0];
  }

  var theChapter = "";
  if (chapterToPlay) {
    theChapter += "?sidedoor=chapter0" + chapterToPlay;
  } else {
    theChapter += "?sidedoor=intro";
  }

  // Add tracking data
  var metricsEnabled = "true";
  if (FlockPrefsUtils.getBoolPref(PREF_FLOCK_METRICS_ENABLED) != null &&
      FlockPrefsUtils.getBoolPref(PREF_FLOCK_METRICS_ENABLED) == false)
  {
    // Explicity turned off, all other cases it must be "on"
    metricsEnabled = "false";
  }
  var uuid = 0;
  uuid = FlockPrefsUtils.getCharPref(PREF_FLOCK_FIRSTRUN_UUID);

  theChapter += "&UUID=" + uuid
              + "&reportMetrics=" + metricsEnabled
              + "&xmlPath=flock_oobe.xml"
              + "&externalServer=" + METRICS_TRACKING_SERVER;

  var flashContainerVbox = document.getElementById("flashContainerVbox");
  var flashEmbed = document.createElementNS("http://www.w3.org/1999/xhtml",
                                            "html:embed");
  flashEmbed.setAttribute("id", "flashID");
  flashEmbed.setAttribute("class", "flashContainer");
  flashEmbed.setAttribute("width", "800");
  flashEmbed.setAttribute("height", "550");
  flashEmbed.setAttribute("type", "application/x-shockwave-flash");
  flashEmbed.setAttribute("src", OOBE_CHROME_LOCATION + theChapter);
  flashContainerVbox.appendChild(flashEmbed);

  flashEmbed.focus();

  // Instrumentation
  gMetricsSvc.report("OOBEDialog-Opened", chapterToPlay);
} 

function onUnLoad() {
  gHiddenWindow.oobeDialogOpen = false;

  var prefService = CC["@mozilla.org/preferences-service;1"]
                    .getService(CI.nsIPrefBranch);

  // Instrumentation
  gMetricsSvc.report("OOBEDialog-Close", null);
}
